/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atomix.primitive.PrimitiveId;
import io.atomix.protocols.raft.storage.RaftStorage;
import io.atomix.protocols.raft.storage.snapshot.FileSnapshot;
import io.atomix.protocols.raft.storage.snapshot.MemorySnapshot;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotDescriptor;
import io.atomix.protocols.raft.storage.snapshot.SnapshotFile;
import io.atomix.storage.StorageLevel;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.FileBuffer;
import io.atomix.storage.buffer.HeapBuffer;
import io.atomix.utils.time.WallClockTimestamp;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotStore
implements AutoCloseable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final RaftStorage storage;
    private final Map<Long, Set<Snapshot>> indexSnapshots = new ConcurrentHashMap<Long, Set<Snapshot>>();
    private final Map<PrimitiveId, Snapshot> serviceSnapshots = new ConcurrentHashMap<PrimitiveId, Snapshot>();

    public SnapshotStore(RaftStorage storage) {
        this.storage = (RaftStorage)Preconditions.checkNotNull((Object)storage, (Object)"storage cannot be null");
        this.open();
    }

    private void open() {
        for (Snapshot snapshot : this.loadSnapshots()) {
            Snapshot existingSnapshot = this.serviceSnapshots.get(snapshot.serviceId());
            if (existingSnapshot == null || existingSnapshot.index() < snapshot.index()) {
                this.serviceSnapshots.put(snapshot.serviceId(), snapshot);
                if (existingSnapshot == null || this.storage.isRetainStaleSnapshots()) continue;
                existingSnapshot.close();
                existingSnapshot.delete();
                continue;
            }
            snapshot.close();
            snapshot.delete();
        }
        for (Snapshot snapshot : this.serviceSnapshots.values()) {
            this.indexSnapshots.computeIfAbsent(snapshot.index(), i -> Sets.newConcurrentHashSet()).add(snapshot);
        }
    }

    public Snapshot getSnapshot(PrimitiveId serviceId, long index) {
        Collection snapshots = this.indexSnapshots.get(index);
        return snapshots == null ? null : (Snapshot)snapshots.stream().filter(s -> s.serviceId().equals((Object)serviceId)).findFirst().orElse(null);
    }

    public Snapshot getSnapshotById(PrimitiveId id) {
        return this.serviceSnapshots.get(id);
    }

    public Collection<Snapshot> getSnapshotsByIndex(long index) {
        Collection snapshots = this.indexSnapshots.get(index);
        return snapshots != null ? (Collection)snapshots.stream().sorted(Comparator.comparingLong(s -> (Long)s.serviceId().id())).collect(Collectors.toList()) : null;
    }

    private Collection<Snapshot> loadSnapshots() {
        this.storage.directory().mkdirs();
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        for (File file : this.storage.directory().listFiles(File::isFile)) {
            if (!SnapshotFile.isSnapshotFile(file)) continue;
            SnapshotFile snapshotFile = new SnapshotFile(file);
            SnapshotDescriptor descriptor = new SnapshotDescriptor((Buffer)FileBuffer.allocate((File)file, (int)64));
            if (descriptor.isLocked()) {
                this.log.debug("Loaded disk snapshot: {} ({})", (Object)descriptor.index(), (Object)snapshotFile.file().getName());
                snapshots.add(new FileSnapshot(snapshotFile, descriptor, this));
                descriptor.close();
                continue;
            }
            this.log.debug("Deleting partial snapshot: {} ({})", (Object)descriptor.index(), (Object)snapshotFile.file().getName());
            descriptor.close();
            descriptor.delete();
        }
        return snapshots;
    }

    public Snapshot newTemporarySnapshot(PrimitiveId primitiveId, String serviceName, long index, WallClockTimestamp timestamp) {
        SnapshotDescriptor descriptor = SnapshotDescriptor.builder().withServiceId((Long)primitiveId.id()).withIndex(index).withTimestamp(timestamp.unixTimestamp()).build();
        return this.newSnapshot(serviceName, descriptor, StorageLevel.MEMORY);
    }

    public Snapshot newSnapshot(PrimitiveId primitiveId, String serviceName, long index, WallClockTimestamp timestamp) {
        SnapshotDescriptor descriptor = SnapshotDescriptor.builder().withServiceId((Long)primitiveId.id()).withIndex(index).withTimestamp(timestamp.unixTimestamp()).build();
        return this.newSnapshot(serviceName, descriptor, this.storage.storageLevel());
    }

    private Snapshot newSnapshot(String serviceName, SnapshotDescriptor descriptor, StorageLevel storageLevel) {
        if (storageLevel == StorageLevel.MEMORY) {
            return this.createMemorySnapshot(serviceName, descriptor);
        }
        return this.createDiskSnapshot(serviceName, descriptor);
    }

    private Snapshot createMemorySnapshot(String serviceName, SnapshotDescriptor descriptor) {
        HeapBuffer buffer = HeapBuffer.allocate((int)64, (int)Integer.MAX_VALUE);
        MemorySnapshot snapshot = new MemorySnapshot(serviceName, buffer, descriptor.copyTo((Buffer)buffer), this);
        this.log.debug("Created memory snapshot: {}", (Object)snapshot);
        return snapshot;
    }

    private Snapshot createDiskSnapshot(String serviceName, SnapshotDescriptor descriptor) {
        SnapshotFile file = new SnapshotFile(SnapshotFile.createSnapshotFile(this.storage.directory(), serviceName, descriptor.serviceId(), descriptor.index()));
        FileSnapshot snapshot = new FileSnapshot(file, descriptor, this);
        this.log.debug("Created disk snapshot: {}", (Object)snapshot);
        return snapshot;
    }

    protected synchronized void completeSnapshot(Snapshot snapshot) {
        Preconditions.checkNotNull((Object)snapshot, (Object)"snapshot cannot be null");
        Snapshot existingSnapshot = this.serviceSnapshots.get(snapshot.serviceId());
        if (existingSnapshot == null || existingSnapshot.index() < snapshot.index()) {
            this.serviceSnapshots.put(snapshot.serviceId(), snapshot);
            this.indexSnapshots.computeIfAbsent(snapshot.index(), i -> Sets.newConcurrentHashSet()).add(snapshot);
            if (existingSnapshot != null) {
                Set<Snapshot> existingSnapshots = this.indexSnapshots.get(existingSnapshot.index());
                if (existingSnapshots != null) {
                    existingSnapshots.remove(existingSnapshot);
                    if (existingSnapshots.isEmpty()) {
                        this.indexSnapshots.remove(existingSnapshot.index());
                    }
                }
                if (!this.storage.isRetainStaleSnapshots()) {
                    existingSnapshot.close();
                    existingSnapshot.delete();
                }
            }
        } else if (existingSnapshot.index() == snapshot.index()) {
            this.serviceSnapshots.put(snapshot.serviceId(), snapshot);
            Set existingSnapshots = this.indexSnapshots.computeIfAbsent(snapshot.index(), i -> Sets.newConcurrentHashSet());
            existingSnapshots.remove(existingSnapshot);
            existingSnapshots.add(snapshot);
            existingSnapshot.close();
        } else if (!this.storage.isRetainStaleSnapshots()) {
            snapshot.close();
            snapshot.delete();
        }
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

