/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.BufferInput;
import io.atomix.storage.buffer.Bytes;
import java.nio.charset.Charset;

public class SnapshotReader
implements BufferInput<SnapshotReader> {
    private final Buffer buffer;
    private final Snapshot snapshot;

    SnapshotReader(Buffer buffer, Snapshot snapshot) {
        this.buffer = (Buffer)Preconditions.checkNotNull((Object)buffer, (Object)"buffer cannot be null");
        this.snapshot = (Snapshot)Preconditions.checkNotNull((Object)snapshot, (Object)"snapshot cannot be null");
    }

    public Snapshot snapshot() {
        return this.snapshot;
    }

    public int position() {
        return this.buffer.position();
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public SnapshotReader skip(int bytes) {
        this.buffer.skip(bytes);
        return this;
    }

    public SnapshotReader read(Bytes bytes) {
        this.buffer.read(bytes);
        return this;
    }

    public SnapshotReader read(byte[] bytes) {
        this.buffer.read(bytes);
        return this;
    }

    public SnapshotReader read(Bytes bytes, int offset, int length) {
        this.buffer.read(bytes, offset, length);
        return this;
    }

    public SnapshotReader read(byte[] bytes, int offset, int length) {
        this.buffer.read(bytes, offset, length);
        return this;
    }

    public SnapshotReader read(Buffer buffer) {
        this.buffer.read(buffer);
        return this;
    }

    public int readByte() {
        return this.buffer.readByte();
    }

    public int readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    public char readChar() {
        return this.buffer.readChar();
    }

    public short readShort() {
        return this.buffer.readShort();
    }

    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    public int readMedium() {
        return this.buffer.readMedium();
    }

    public int readUnsignedMedium() {
        return this.buffer.readUnsignedMedium();
    }

    public int readInt() {
        return this.buffer.readInt();
    }

    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    public long readLong() {
        return this.buffer.readLong();
    }

    public float readFloat() {
        return this.buffer.readFloat();
    }

    public double readDouble() {
        return this.buffer.readDouble();
    }

    public boolean readBoolean() {
        return this.buffer.readBoolean();
    }

    public String readString() {
        return this.buffer.readString();
    }

    public String readString(Charset charset) {
        return this.buffer.readString(charset);
    }

    public String readUTF8() {
        return this.buffer.readUTF8();
    }

    public void close() {
        this.buffer.close();
        this.snapshot.closeReader(this);
    }
}

