/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.NodeId;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.Recovery;
import io.atomix.primitive.proxy.PrimitiveProxy;
import io.atomix.primitive.proxy.impl.BlockingAwarePrimitiveProxy;
import io.atomix.primitive.proxy.impl.RecoveringPrimitiveProxy;
import io.atomix.primitive.proxy.impl.RetryingPrimitiveProxy;
import io.atomix.protocols.raft.RaftClient;
import io.atomix.protocols.raft.RaftMetadataClient;
import io.atomix.protocols.raft.RaftProtocol;
import io.atomix.protocols.raft.impl.DefaultRaftMetadataClient;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.proxy.impl.DefaultRaftProxy;
import io.atomix.protocols.raft.proxy.impl.MemberSelectorManager;
import io.atomix.protocols.raft.proxy.impl.RaftProxyManager;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.logging.ContextualLogger;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class DefaultRaftClient
implements RaftClient {
    private final String clientId;
    private final Collection<NodeId> cluster;
    private final RaftClientProtocol protocol;
    private final ThreadContextFactory threadContextFactory;
    private final ThreadContext threadContext;
    private final RaftMetadataClient metadata;
    private final MemberSelectorManager selectorManager = new MemberSelectorManager();
    private final RaftProxyManager sessionManager;

    public DefaultRaftClient(String clientId, NodeId nodeId, Collection<NodeId> cluster, RaftClientProtocol protocol, ThreadContextFactory threadContextFactory) {
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"clientId cannot be null");
        this.cluster = (Collection)Preconditions.checkNotNull(cluster, (Object)"cluster cannot be null");
        this.protocol = (RaftClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.threadContextFactory = (ThreadContextFactory)Preconditions.checkNotNull((Object)threadContextFactory, (Object)"threadContextFactory cannot be null");
        this.threadContext = threadContextFactory.createContext();
        this.metadata = new DefaultRaftMetadataClient(clientId, protocol, this.selectorManager, threadContextFactory.createContext());
        this.sessionManager = new RaftProxyManager(clientId, nodeId, protocol, this.selectorManager, threadContextFactory);
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    @Override
    public long term() {
        return this.sessionManager.term();
    }

    @Override
    public NodeId leader() {
        return this.sessionManager.leader();
    }

    @Override
    public RaftMetadataClient metadata() {
        return this.metadata;
    }

    @Override
    public synchronized CompletableFuture<RaftClient> connect(Collection<NodeId> cluster) {
        CompletableFuture<RaftClient> future = new CompletableFuture<RaftClient>();
        if (cluster == null || cluster.isEmpty()) {
            cluster = this.cluster;
        }
        if (cluster == null || cluster.isEmpty()) {
            throw new IllegalArgumentException("No cluster specified");
        }
        this.sessionManager.resetConnections(null, cluster);
        this.sessionManager.open().whenCompleteAsync((result, error) -> {
            if (error == null) {
                future.complete(this);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }, (Executor)this.threadContext);
        return future;
    }

    public PrimitiveProxy newProxy(String primitiveName, PrimitiveType primitiveType, RaftProtocol primitiveProtocol) {
        Supplier<PrimitiveProxy> proxyFactory = () -> new DefaultRaftProxy(primitiveName, primitiveType, this.protocol, this.selectorManager, this.sessionManager, primitiveProtocol.readConsistency(), primitiveProtocol.communicationStrategy(), this.threadContextFactory.createContext(), primitiveProtocol.minTimeout(), primitiveProtocol.maxTimeout());
        Object proxy = primitiveProtocol.recoveryStrategy() == Recovery.RECOVER ? new RecoveringPrimitiveProxy(this.clientId, primitiveName, primitiveType, proxyFactory, (Scheduler)this.threadContextFactory.createContext()) : proxyFactory.get();
        if (primitiveProtocol.maxRetries() > 0) {
            proxy = new RetryingPrimitiveProxy(proxy, (Scheduler)this.threadContextFactory.createContext(), primitiveProtocol.maxRetries(), primitiveProtocol.retryDelay());
        }
        Executor executor = primitiveProtocol.executor() != null ? primitiveProtocol.executor() : this.threadContextFactory.createContext();
        return new BlockingAwarePrimitiveProxy(proxy, executor);
    }

    public CompletableFuture<Set<String>> getPrimitives(PrimitiveType primitiveType) {
        return this.metadata.getSessions(primitiveType).thenApply(result -> result.stream().map(m -> m.primitiveName()).collect(Collectors.toSet()));
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return this.sessionManager.close().thenRunAsync(() -> ((ThreadContextFactory)this.threadContextFactory).close());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.clientId).toString();
    }

    public static class Builder
    extends RaftClient.Builder {
        public Builder(Collection<NodeId> cluster) {
            super(cluster);
        }

        public RaftClient build() {
            Preconditions.checkNotNull((Object)this.nodeId, (Object)"nodeId cannot be null");
            ContextualLogger log = ContextualLoggerFactory.getLogger(DefaultRaftClient.class, (LoggerContext)LoggerContext.builder(RaftClient.class).addValue((Object)this.clientId).build());
            ThreadContextFactory threadContextFactory = this.threadModel.factory("raft-client-" + this.clientId + "-%d", this.threadPoolSize, (Logger)log);
            return new DefaultRaftClient(this.clientId, this.nodeId, this.cluster, this.protocol, threadContextFactory);
        }
    }
}

