/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.storage.RaftStorage;
import io.atomix.protocols.raft.storage.snapshot.FileSnapshot;
import io.atomix.protocols.raft.storage.snapshot.MemorySnapshot;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotDescriptor;
import io.atomix.protocols.raft.storage.snapshot.SnapshotFile;
import io.atomix.storage.StorageLevel;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.FileBuffer;
import io.atomix.storage.buffer.HeapBuffer;
import io.atomix.time.WallClockTimestamp;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotStore
implements AutoCloseable {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final RaftStorage storage;
    private final Map<Long, Snapshot> indexSnapshots = new ConcurrentHashMap<Long, Snapshot>();
    private final Map<ServiceId, Snapshot> stateMachineSnapshots = new ConcurrentHashMap<ServiceId, Snapshot>();

    public SnapshotStore(RaftStorage storage) {
        this.storage = (RaftStorage)Preconditions.checkNotNull((Object)storage, (Object)"storage cannot be null");
        this.open();
    }

    private void open() {
        for (Snapshot snapshot : this.loadSnapshots()) {
            Snapshot existingSnapshot = this.stateMachineSnapshots.get((Object)snapshot.serviceId());
            if (existingSnapshot != null && existingSnapshot.index() >= snapshot.index()) continue;
            this.stateMachineSnapshots.put(snapshot.serviceId(), snapshot);
            if (existingSnapshot == null || this.storage.isRetainStaleSnapshots()) continue;
            existingSnapshot.close();
            existingSnapshot.delete();
        }
        for (Snapshot snapshot : this.stateMachineSnapshots.values()) {
            this.indexSnapshots.put(snapshot.index(), snapshot);
        }
    }

    public Snapshot getSnapshotById(ServiceId id) {
        return this.stateMachineSnapshots.get((Object)id);
    }

    public Snapshot getSnapshotByIndex(long index) {
        return this.indexSnapshots.get(index);
    }

    private Collection<Snapshot> loadSnapshots() {
        this.storage.directory().mkdirs();
        ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
        for (File file : this.storage.directory().listFiles(File::isFile)) {
            if (!SnapshotFile.isSnapshotFile(this.storage.prefix(), file)) continue;
            SnapshotFile snapshotFile = new SnapshotFile(file);
            SnapshotDescriptor descriptor = new SnapshotDescriptor((Buffer)FileBuffer.allocate((File)file, (int)64));
            if (descriptor.isLocked()) {
                this.log.debug("Loaded disk snapshot: {} ({})", (Object)snapshotFile.index(), (Object)snapshotFile.file().getName());
                snapshots.add(new FileSnapshot(snapshotFile, this));
                descriptor.close();
                continue;
            }
            this.log.debug("Deleting partial snapshot: {} ({})", (Object)descriptor.index(), (Object)snapshotFile.file().getName());
            descriptor.close();
            descriptor.delete();
        }
        return snapshots;
    }

    public Snapshot newTemporarySnapshot(ServiceId serviceId, long index, WallClockTimestamp timestamp) {
        SnapshotDescriptor descriptor = SnapshotDescriptor.newBuilder().withId((Long)serviceId.id()).withIndex(index).withTimestamp(timestamp.unixTimestamp()).build();
        return this.newSnapshot(descriptor, StorageLevel.MEMORY);
    }

    public Snapshot newSnapshot(ServiceId serviceId, long index, WallClockTimestamp timestamp) {
        SnapshotDescriptor descriptor = SnapshotDescriptor.newBuilder().withId((Long)serviceId.id()).withIndex(index).withTimestamp(timestamp.unixTimestamp()).build();
        return this.newSnapshot(descriptor, this.storage.storageLevel());
    }

    private Snapshot newSnapshot(SnapshotDescriptor descriptor, StorageLevel storageLevel) {
        if (storageLevel == StorageLevel.MEMORY) {
            return this.createMemorySnapshot(descriptor);
        }
        return this.createDiskSnapshot(descriptor);
    }

    private Snapshot createMemorySnapshot(SnapshotDescriptor descriptor) {
        HeapBuffer buffer = HeapBuffer.allocate((int)64, (int)Integer.MAX_VALUE);
        MemorySnapshot snapshot = new MemorySnapshot(buffer, descriptor.copyTo((Buffer)buffer), this);
        this.log.debug("Created memory snapshot: {}", (Object)snapshot);
        return snapshot;
    }

    private Snapshot createDiskSnapshot(SnapshotDescriptor descriptor) {
        SnapshotFile file = new SnapshotFile(SnapshotFile.createSnapshotFile(this.storage.prefix(), this.storage.directory(), descriptor.snapshotId(), descriptor.index(), descriptor.timestamp()));
        FileSnapshot snapshot = new FileSnapshot(file, this);
        this.log.debug("Created disk snapshot: {}", (Object)snapshot);
        return snapshot;
    }

    protected synchronized void completeSnapshot(Snapshot snapshot) {
        Preconditions.checkNotNull((Object)snapshot, (Object)"snapshot cannot be null");
        Snapshot existingSnapshot = this.stateMachineSnapshots.get((Object)snapshot.serviceId());
        if (existingSnapshot == null || existingSnapshot.index() <= snapshot.index()) {
            this.stateMachineSnapshots.put(snapshot.serviceId(), snapshot);
            this.indexSnapshots.put(snapshot.index(), snapshot);
            if (existingSnapshot != null) {
                this.indexSnapshots.remove(existingSnapshot.index());
                if (!this.storage.isRetainStaleSnapshots()) {
                    existingSnapshot.close();
                    existingSnapshot.delete();
                }
            }
        } else if (!this.storage.isRetainStaleSnapshots()) {
            snapshot.close();
            snapshot.delete();
        }
    }

    @Override
    public void close() {
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

