/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session.impl;

import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.session.RaftSessionListener;
import io.atomix.protocols.raft.session.SessionId;
import io.atomix.protocols.raft.session.impl.RaftSessionContext;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;

public class RaftSessionManager {
    private final Map<Long, RaftSessionContext> sessions = new ConcurrentHashMap<Long, RaftSessionContext>();
    private final Map<ServiceId, Set<RaftSessionListener>> listeners = new ConcurrentHashMap<ServiceId, Set<RaftSessionListener>>();

    public void registerSession(RaftSessionContext session) {
        Set<RaftSessionListener> listeners;
        if (this.sessions.putIfAbsent((Long)session.sessionId().id(), session) == null && (listeners = this.listeners.get((Object)session.getService().serviceId())) != null) {
            listeners.forEach(l -> l.onOpen(session));
        }
    }

    public void expireSession(SessionId sessionId) {
        RaftSessionContext session = this.sessions.remove(sessionId.id());
        if (session != null) {
            Set<RaftSessionListener> listeners = this.listeners.get((Object)session.getService().serviceId());
            if (listeners != null) {
                listeners.forEach(l -> l.onExpire(session));
            }
            session.expire();
        }
    }

    public void closeSession(SessionId sessionId) {
        RaftSessionContext session = this.sessions.remove(sessionId.id());
        if (session != null) {
            Set<RaftSessionListener> listeners = this.listeners.get((Object)session.getService().serviceId());
            if (listeners != null) {
                listeners.forEach(l -> l.onClose(session));
            }
            session.close();
        }
    }

    public RaftSessionContext getSession(SessionId sessionId) {
        return this.getSession((Long)sessionId.id());
    }

    public RaftSessionContext getSession(long sessionId) {
        return this.sessions.get(sessionId);
    }

    public Collection<RaftSessionContext> getSessions() {
        return this.sessions.values();
    }

    public Collection<RaftSessionContext> getSessions(ServiceId serviceId) {
        return this.sessions.values().stream().filter(session -> session.getService().serviceId().equals((Object)serviceId)).collect(Collectors.toSet());
    }

    public void addListener(ServiceId serviceId, RaftSessionListener sessionListener) {
        Set sessionListeners = this.listeners.computeIfAbsent(serviceId, k -> new CopyOnWriteArraySet());
        sessionListeners.add(sessionListener);
    }

    public void removeListener(ServiceId serviceId, RaftSessionListener sessionListener) {
        Set<RaftSessionListener> sessionListeners = this.listeners.get((Object)serviceId);
        if (sessionListeners != null) {
            sessionListeners.remove(sessionListener);
            if (sessionListeners.isEmpty()) {
                this.listeners.remove((Object)serviceId);
            }
        }
    }
}

