/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.impl.OperationResult;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.OperationResponse;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.roles.PendingSnapshot;
import io.atomix.protocols.raft.roles.RaftRole;
import io.atomix.protocols.raft.roles.ReserveRole;
import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.session.impl.RaftSessionContext;
import io.atomix.protocols.raft.storage.log.RaftLogReader;
import io.atomix.protocols.raft.storage.log.RaftLogWriter;
import io.atomix.protocols.raft.storage.log.entry.QueryEntry;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotWriter;
import io.atomix.storage.journal.Indexed;
import io.atomix.time.WallClockTimestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class PassiveRole
extends ReserveRole {
    private final Map<Long, PendingSnapshot> pendingSnapshots = new HashMap<Long, PendingSnapshot>();

    public PassiveRole(RaftContext context) {
        super(context);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.PASSIVE;
    }

    @Override
    public CompletableFuture<RaftRole> open() {
        return ((CompletableFuture)super.open().thenRun(this::truncateUncommittedEntries)).thenApply(v -> this);
    }

    private void truncateUncommittedEntries() {
        if (this.role() == RaftServer.Role.PASSIVE) {
            RaftLogWriter writer = this.raft.getLogWriter();
            writer.truncate(this.raft.getCommitIndex());
        }
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        return this.handleAppend(request);
    }

    protected CompletableFuture<AppendResponse> handleAppend(AppendRequest request) {
        CompletableFuture<AppendResponse> future = new CompletableFuture<AppendResponse>();
        if (!this.checkTerm(request, future)) {
            return future;
        }
        if (!this.checkPreviousEntry(request, future)) {
            return future;
        }
        this.appendEntries(request, future);
        return future;
    }

    protected boolean checkTerm(AppendRequest request, CompletableFuture<AppendResponse> future) {
        RaftLogWriter writer = this.raft.getLogWriter();
        if (request.term() < this.raft.getTerm()) {
            this.log.debug("Rejected {}: request term is less than the current term ({})", (Object)request, (Object)this.raft.getTerm());
            return this.failAppend(writer.getLastIndex(), future);
        }
        return true;
    }

    protected boolean checkPreviousEntry(AppendRequest request, CompletableFuture<AppendResponse> future) {
        RaftLogWriter writer = this.raft.getLogWriter();
        RaftLogReader reader = this.raft.getLogReader();
        if (request.prevLogTerm() != 0L) {
            Indexed lastEntry = writer.getLastEntry();
            if (lastEntry != null) {
                if (request.prevLogIndex() > lastEntry.index()) {
                    this.log.debug("Rejected {}: Previous index ({}) is greater than the local log's last index ({})", new Object[]{request, request.prevLogIndex(), lastEntry.index()});
                    return this.failAppend(lastEntry.index(), future);
                }
                if (request.prevLogIndex() < lastEntry.index()) {
                    reader.reset(request.prevLogIndex());
                    if (!reader.hasNext()) {
                        this.log.debug("Rejected {}: Previous entry does not exist in the local log", (Object)request);
                        return this.failAppend(lastEntry.index(), future);
                    }
                    Indexed previousEntry = reader.next();
                    if (request.prevLogTerm() != ((RaftLogEntry)previousEntry.entry()).term()) {
                        this.log.debug("Rejected {}: Previous entry term ({}) does not match local log's term for the same entry ({})", new Object[]{request, request.prevLogTerm(), ((RaftLogEntry)previousEntry.entry()).term()});
                        return this.failAppend(request.prevLogIndex() - 1L, future);
                    }
                } else if (request.prevLogTerm() != ((RaftLogEntry)lastEntry.entry()).term()) {
                    this.log.debug("Rejected {}: Previous entry term ({}) does not equal the local log's last term ({})", new Object[]{request, request.prevLogTerm(), ((RaftLogEntry)lastEntry.entry()).term()});
                    return this.failAppend(request.prevLogIndex() - 1L, future);
                }
            } else if (request.prevLogIndex() > 0L) {
                this.log.debug("Rejected {}: Previous index ({}) is greater than the local log's last index (0)", (Object)request, (Object)request.prevLogIndex());
                return this.failAppend(0L, future);
            }
        }
        return true;
    }

    protected void appendEntries(AppendRequest request, CompletableFuture<AppendResponse> future) {
        long lastEntryIndex = request.prevLogIndex() + (long)request.entries().size();
        long commitIndex = Math.max(this.raft.getCommitIndex(), Math.min(request.commitIndex(), lastEntryIndex));
        long lastLogIndex = request.prevLogIndex();
        if (!request.entries().isEmpty()) {
            RaftLogWriter writer = this.raft.getLogWriter();
            RaftLogReader reader = this.raft.getLogReader();
            if (request.prevLogTerm() == 0L) {
                this.log.debug("Reset first index to {}", (Object)(request.prevLogIndex() + 1L));
                writer.reset(request.prevLogIndex() + 1L);
            }
            for (RaftLogEntry entry : request.entries()) {
                Indexed indexed;
                long index = ++lastLogIndex;
                Indexed lastEntry = writer.getLastEntry();
                if (lastEntry != null) {
                    if (lastEntry.index() > index) {
                        reader.reset(index);
                        if (!reader.hasNext()) {
                            throw new IllegalStateException("Log reader inconsistent with log writer");
                        }
                        Indexed existingEntry = reader.next();
                        if (((RaftLogEntry)existingEntry.entry()).term() != entry.term()) {
                            writer.truncate(index - 1L);
                            Indexed indexed2 = writer.append(entry);
                            this.log.trace("Appended {}", (Object)indexed2);
                        }
                    } else if (lastEntry.index() == index) {
                        if (((RaftLogEntry)lastEntry.entry()).term() != entry.term()) {
                            writer.truncate(index - 1L);
                            indexed = writer.append(entry);
                            this.log.trace("Appended {}", (Object)indexed);
                        }
                    } else {
                        if (lastEntry.index() != index - 1L) {
                            throw new IllegalStateException("Log writer inconsistent with next append entry index " + index);
                        }
                        indexed = writer.append(entry);
                        this.log.trace("Appended {}", (Object)indexed);
                    }
                } else {
                    indexed = writer.append(entry);
                    this.log.trace("Appended {}", (Object)indexed);
                }
                if (this.role().active() || index != commitIndex) continue;
                break;
            }
        }
        this.raft.setFirstCommitIndex(request.commitIndex());
        long previousCommitIndex = this.raft.setCommitIndex(commitIndex);
        if (previousCommitIndex < commitIndex) {
            this.log.trace("Committed entries up to index {}", (Object)commitIndex);
            this.raft.getStateMachine().applyAll(commitIndex);
        }
        this.succeedAppend(lastLogIndex, future);
    }

    protected boolean failAppend(long lastLogIndex, CompletableFuture<AppendResponse> future) {
        return this.completeAppend(false, lastLogIndex, future);
    }

    protected boolean succeedAppend(long lastLogIndex, CompletableFuture<AppendResponse> future) {
        return this.completeAppend(true, lastLogIndex, future);
    }

    protected boolean completeAppend(boolean succeeded, long lastLogIndex, CompletableFuture<AppendResponse> future) {
        future.complete(this.logResponse(((AppendResponse.Builder)AppendResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withSucceeded(succeeded).withLastLogIndex(lastLogIndex).build()));
        return succeeded;
    }

    @Override
    public CompletableFuture<QueryResponse> onQuery(QueryRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLastApplied() < request.session()) {
            this.log.trace("State out of sync, forwarding query to leader");
            return this.queryForward(request);
        }
        RaftSessionContext session = this.raft.getStateMachine().getSessions().getSession(request.session());
        if (session == null) {
            this.log.trace("State out of sync, forwarding query to leader");
            return this.queryForward(request);
        }
        if (session.readConsistency() == ReadConsistency.SEQUENTIAL) {
            if (this.raft.getLogWriter().getLastIndex() < this.raft.getCommitIndex()) {
                this.log.trace("State out of sync, forwarding query to leader");
                return this.queryForward(request);
            }
            Indexed entry = new Indexed(request.index(), (Object)new QueryEntry(this.raft.getTerm(), System.currentTimeMillis(), request.session(), request.sequenceNumber(), request.operation()), 0);
            return this.applyQuery((Indexed<QueryEntry>)entry).thenApply(this::logResponse);
        }
        return this.queryForward(request);
    }

    private CompletableFuture<QueryResponse> queryForward(QueryRequest request) {
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        this.log.trace("Forwarding {}", (Object)request);
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::query).exceptionally(error -> ((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    protected CompletableFuture<QueryResponse> queryLocal(Indexed<QueryEntry> entry) {
        return this.applyQuery(entry);
    }

    protected CompletableFuture<QueryResponse> applyQuery(Indexed<QueryEntry> entry) {
        CompletableFuture<QueryResponse> future = new CompletableFuture<QueryResponse>();
        this.raft.getStateMachine().apply(entry).whenComplete((result, error) -> this.completeOperation((OperationResult)result, QueryResponse.newBuilder(), (Throwable)error, future));
        return future;
    }

    protected <T extends OperationResponse> void completeOperation(OperationResult result, OperationResponse.Builder<?, T> builder, Throwable error, CompletableFuture<T> future) {
        if (result != null) {
            builder.withIndex(result.index());
            builder.withEventIndex(result.eventIndex());
            if (result.failed()) {
                error = result.error();
            }
        }
        if (error == null) {
            future.complete(((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.OK)).withResult(result != null ? result.result() : null).build());
        } else if (error instanceof CompletionException && error.getCause() instanceof RaftException) {
            future.complete(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)error.getCause()).getType(), error.getMessage())).build());
        } else if (error instanceof RaftException) {
            future.complete(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)error).getType(), error.getMessage())).build());
        } else {
            this.log.warn("An unexpected error occurred: {}", error);
            future.complete(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR, error.getMessage())).build());
        }
    }

    @Override
    public CompletableFuture<InstallResponse> onInstall(InstallRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        if (request.term() < this.raft.getTerm()) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request term is less than the local term " + request.term())).build()));
        }
        PendingSnapshot pendingSnapshot = this.pendingSnapshots.get(request.snapshotId());
        if (pendingSnapshot != null && request.snapshotIndex() != pendingSnapshot.snapshot().index()) {
            pendingSnapshot.rollback();
            pendingSnapshot = null;
        }
        if (pendingSnapshot == null) {
            if (request.chunkOffset() > 0) {
                return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request chunk offset is invalid")).build()));
            }
            Snapshot snapshot = this.raft.getSnapshotStore().newSnapshot(ServiceId.from(request.snapshotId()), request.snapshotIndex(), WallClockTimestamp.from((long)request.snapshotTimestamp()));
            pendingSnapshot = new PendingSnapshot(snapshot);
        }
        if ((long)request.chunkOffset() > pendingSnapshot.nextOffset()) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request chunk offset does not match the next chunk offset")).build()));
        }
        try (SnapshotWriter writer = pendingSnapshot.snapshot().openWriter();){
            writer.write(request.data());
        }
        if (request.complete()) {
            pendingSnapshot.commit();
            this.pendingSnapshots.remove(request.snapshotId());
        } else {
            pendingSnapshot.incrementOffset();
            this.pendingSnapshots.put(request.snapshotId(), pendingSnapshot);
        }
        return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)InstallResponse.newBuilder().withStatus(RaftResponse.Status.OK)).build()));
    }

    @Override
    public CompletableFuture<Void> close() {
        for (PendingSnapshot pendingSnapshot : this.pendingSnapshots.values()) {
            pendingSnapshot.rollback();
        }
        return super.close();
    }
}

