/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.cluster.RaftCluster;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.storage.RaftStorage;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class DefaultRaftServer
implements RaftServer {
    private final Logger log;
    protected final RaftContext context;
    private volatile CompletableFuture<RaftServer> openFuture;
    private volatile CompletableFuture<Void> closeFuture;
    private volatile boolean started;

    public DefaultRaftServer(RaftContext context) {
        this.context = (RaftContext)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftServer.class).addValue((Object)context.getName()).build());
    }

    @Override
    public String name() {
        return this.context.getName();
    }

    @Override
    public RaftCluster cluster() {
        return this.context.getCluster();
    }

    @Override
    public RaftServer.Role getRole() {
        return this.context.getRole();
    }

    @Override
    public void addRoleChangeListener(Consumer<RaftServer.Role> listener) {
        this.context.addRoleChangeListener(listener);
    }

    @Override
    public void removeRoleChangeListener(Consumer<RaftServer.Role> listener) {
        this.context.removeRoleChangeListener(listener);
    }

    @Override
    public CompletableFuture<RaftServer> bootstrap(Collection<MemberId> cluster) {
        return this.start(() -> this.cluster().bootstrap(cluster));
    }

    @Override
    public CompletableFuture<RaftServer> join(Collection<MemberId> cluster) {
        return this.start(() -> this.cluster().join(cluster));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<RaftServer> start(Supplier<CompletableFuture<Void>> joiner) {
        if (this.started) {
            return CompletableFuture.completedFuture(this);
        }
        if (this.openFuture == null) {
            DefaultRaftServer defaultRaftServer = this;
            synchronized (defaultRaftServer) {
                if (this.openFuture == null) {
                    CompletableFuture future = new CompletableFuture();
                    this.openFuture = future;
                    joiner.get().whenComplete((result, error) -> {
                        if (error == null) {
                            this.context.awaitState(RaftContext.State.READY, state -> {
                                this.started = true;
                                future.complete(null);
                            });
                        } else {
                            future.completeExceptionally((Throwable)error);
                        }
                    });
                }
            }
        }
        return this.openFuture.whenComplete((result, error) -> {
            if (error == null) {
                this.log.info("Server started successfully!");
            } else {
                this.log.warn("Failed to start server!");
            }
        });
    }

    @Override
    public CompletableFuture<RaftServer> promote() {
        return this.context.anoint().thenApply(v -> this);
    }

    @Override
    public boolean isRunning() {
        return this.started;
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        if (!this.started) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("context not open"));
        }
        CompletableFuture future = new CompletableFuture();
        this.context.getThreadContext().execute(() -> {
            this.started = false;
            this.context.transition(RaftServer.Role.INACTIVE);
            future.complete(null);
        });
        return future.whenCompleteAsync((result, error) -> {
            this.context.close();
            this.started = false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> leave() {
        if (!this.started) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.closeFuture == null) {
            DefaultRaftServer defaultRaftServer = this;
            synchronized (defaultRaftServer) {
                if (this.closeFuture == null) {
                    this.closeFuture = new CompletableFuture();
                    if (this.openFuture == null) {
                        this.cluster().leave().whenComplete((leaveResult, leaveError) -> this.shutdown().whenComplete((shutdownResult, shutdownError) -> {
                            this.context.delete();
                            this.closeFuture.complete(null);
                        }));
                    } else {
                        this.openFuture.whenComplete((openResult, openError) -> {
                            if (openError == null) {
                                this.cluster().leave().whenComplete((leaveResult, leaveError) -> this.shutdown().whenComplete((shutdownResult, shutdownError) -> {
                                    this.context.delete();
                                    this.closeFuture.complete(null);
                                }));
                            } else {
                                this.closeFuture.complete(null);
                            }
                        });
                    }
                }
            }
        }
        return this.closeFuture;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name()).toString();
    }

    public static class Builder
    extends RaftServer.Builder {
        public Builder(MemberId localMemberId) {
            super(localMemberId);
        }

        public RaftServer build() {
            if (this.serviceRegistry.size() == 0) {
                throw new IllegalStateException("No state machines registered");
            }
            if (this.name == null) {
                this.name = (String)((Object)this.localMemberId.id());
            }
            if (this.storage == null) {
                this.storage = RaftStorage.newBuilder().build();
            }
            RaftContext raft = new RaftContext(this.name, this.type, this.localMemberId, this.protocol, this.storage, this.serviceRegistry, this.threadModel, this.threadPoolSize);
            raft.setElectionTimeout(this.electionTimeout);
            raft.setHeartbeatInterval(this.heartbeatInterval);
            raft.setSessionTimeout(this.sessionTimeout);
            return new DefaultRaftServer(raft);
        }
    }
}

