/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import io.atomix.protocols.raft.event.RaftEvent;
import io.atomix.protocols.raft.operation.RaftOperation;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.proxy.RaftProxyClient;
import io.atomix.protocols.raft.proxy.impl.DelegatingRaftProxyClient;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.ThreadContext;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class BlockingAwareRaftProxyClient
extends DelegatingRaftProxyClient {
    private final ThreadContext context;
    private final Map<Consumer<RaftProxy.State>, Consumer<RaftProxy.State>> stateChangeListeners = Maps.newConcurrentMap();
    private final Map<Consumer<RaftEvent>, Consumer<RaftEvent>> eventListeners = Maps.newConcurrentMap();

    public BlockingAwareRaftProxyClient(RaftProxyClient delegate, ThreadContext context) {
        super(delegate);
        this.context = (ThreadContext)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
    }

    @Override
    public void addStateChangeListener(Consumer<RaftProxy.State> listener) {
        Consumer<RaftProxy.State> wrappedListener = state -> this.context.execute(() -> listener.accept((RaftProxy.State)((Object)state)));
        this.stateChangeListeners.put(listener, wrappedListener);
        super.addStateChangeListener(wrappedListener);
    }

    @Override
    public void removeStateChangeListener(Consumer<RaftProxy.State> listener) {
        Consumer<RaftProxy.State> wrappedListener = this.stateChangeListeners.remove(listener);
        if (wrappedListener != null) {
            super.removeStateChangeListener(wrappedListener);
        }
    }

    @Override
    public CompletableFuture<byte[]> execute(RaftOperation operation) {
        return Futures.asyncFuture(super.execute(operation), (Executor)this.context);
    }

    @Override
    public void addEventListener(Consumer<RaftEvent> listener) {
        Consumer<RaftEvent> wrappedListener = e -> this.context.execute(() -> listener.accept((RaftEvent)e));
        this.eventListeners.put(listener, wrappedListener);
        super.addEventListener(wrappedListener);
    }

    @Override
    public void removeEventListener(Consumer<RaftEvent> listener) {
        Consumer<RaftEvent> wrappedListener = this.eventListeners.remove(listener);
        if (wrappedListener != null) {
            super.removeEventListener(wrappedListener);
        }
    }
}

