/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.protocol.AbstractRaftResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.service.PropagationStrategy;
import java.util.Objects;

public class OpenSessionResponse
extends AbstractRaftResponse {
    protected final long session;
    protected final long timeout;
    protected final int revision;
    protected final PropagationStrategy propagationStrategy;

    public static Builder newBuilder() {
        return new Builder();
    }

    public OpenSessionResponse(RaftResponse.Status status, RaftError error, long session, long timeout, int revision, PropagationStrategy propagationStrategy) {
        super(status, error);
        this.session = session;
        this.timeout = timeout;
        this.revision = revision;
        this.propagationStrategy = propagationStrategy;
    }

    public long session() {
        return this.session;
    }

    public long timeout() {
        return this.timeout;
    }

    public int revision() {
        return this.revision;
    }

    public PropagationStrategy propagationStrategy() {
        return this.propagationStrategy;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.error, this.status, this.session, this.timeout});
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof OpenSessionResponse) {
            OpenSessionResponse response = (OpenSessionResponse)object;
            return response.status == this.status && Objects.equals(response.error, this.error) && response.session == this.session && response.timeout == this.timeout;
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.status == RaftResponse.Status.OK) {
            return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("session", this.session).add("timeout", this.timeout).add("revision", this.revision).toString();
        }
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("error", (Object)this.error).toString();
    }

    public static class Builder
    extends AbstractRaftResponse.Builder<Builder, OpenSessionResponse> {
        private long session;
        private long timeout;
        private int revision;
        private PropagationStrategy propagationStrategy;

        public Builder withSession(long session) {
            Preconditions.checkArgument((session > 0L ? 1 : 0) != 0, (Object)"session must be positive");
            this.session = session;
            return this;
        }

        public Builder withTimeout(long timeout) {
            Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0, (Object)"timeout must be positive");
            this.timeout = timeout;
            return this;
        }

        public Builder withRevision(int revision) {
            Preconditions.checkArgument((revision > 0 ? 1 : 0) != 0, (Object)"revision must be positive");
            this.revision = revision;
            return this;
        }

        public Builder withPropagationStrategy(PropagationStrategy propagationStrategy) {
            this.propagationStrategy = (PropagationStrategy)((Object)Preconditions.checkNotNull((Object)((Object)propagationStrategy)));
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.status == RaftResponse.Status.OK) {
                Preconditions.checkArgument((this.session > 0L ? 1 : 0) != 0, (Object)"session must be positive");
                Preconditions.checkArgument((this.timeout > 0L ? 1 : 0) != 0, (Object)"timeout must be positive");
                Preconditions.checkArgument((this.revision > 0 ? 1 : 0) != 0, (Object)"revision must be positive");
                Preconditions.checkNotNull((Object)((Object)this.propagationStrategy), (Object)"propagationStrategy must not be null");
            }
        }

        public OpenSessionResponse build() {
            this.validate();
            return new OpenSessionResponse(this.status, this.error, this.session, this.timeout, this.revision, this.propagationStrategy);
        }
    }
}

