/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.protocol.RaftMessage;

public interface RaftResponse
extends RaftMessage {
    public Status status();

    public RaftError error();

    public static interface Builder<T extends Builder<T, U>, U extends RaftResponse>
    extends io.atomix.utils.Builder<U> {
        public T withStatus(Status var1);

        default public T withError(RaftError.Type type) {
            return this.withError(new RaftError(type, null));
        }

        default public T withError(RaftError.Type type, String message) {
            return this.withError(new RaftError(type, message));
        }

        public T withError(RaftError var1);
    }

    public static enum Status {
        OK(1),
        ERROR(0);

        private final byte id;

        public static Status forId(int id) {
            switch (id) {
                case 1: {
                    return OK;
                }
                case 0: {
                    return ERROR;
                }
            }
            throw new IllegalArgumentException("invalid status identifier: " + id);
        }

        private Status(int id) {
            this.id = (byte)id;
        }

        public byte id() {
            return this.id;
        }
    }
}

