/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.service.ServiceId;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class SnapshotFile {
    @VisibleForTesting
    static final SimpleDateFormat TIMESTAMP_FORMAT = new SimpleDateFormat("yyyyMMddHHmmssSSS");
    private static final char PART_SEPARATOR = '-';
    private static final char EXTENSION_SEPARATOR = '.';
    private static final String EXTENSION = "snapshot";
    private final File file;

    public static boolean isSnapshotFile(String name, File file) {
        Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        Preconditions.checkNotNull((Object)file, (Object)"file cannot be null");
        String fileName = file.getName();
        if (fileName.lastIndexOf(46) == -1) {
            return false;
        }
        if (!fileName.endsWith(".snapshot")) {
            return false;
        }
        String[] parts = fileName.split(String.valueOf('-'));
        if (parts.length < 4) {
            return false;
        }
        if (!parts[parts.length - 4].equals(name)) {
            return false;
        }
        if (!SnapshotFile.isNumeric(parts[parts.length - 3])) {
            return false;
        }
        return SnapshotFile.isNumeric(parts[parts.length - 2]);
    }

    private static boolean isNumeric(String value) {
        for (char c : value.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static File createSnapshotFile(String name, File directory, long id, long index, long timestamp) {
        return new File(directory, SnapshotFile.createSnapshotFileName(name, id, index, timestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    static String createSnapshotFileName(String name, long id, long index, long timestamp) {
        SimpleDateFormat simpleDateFormat = TIMESTAMP_FORMAT;
        synchronized (simpleDateFormat) {
            return String.format("%s-%d-%d-%s.%s", Preconditions.checkNotNull((Object)name, (Object)"name cannot be null"), id, index, TIMESTAMP_FORMAT.format(new Date(timestamp)), EXTENSION);
        }
    }

    SnapshotFile(File file) {
        this.file = file;
    }

    public File file() {
        return this.file;
    }

    public ServiceId snapshotId() {
        return ServiceId.from(SnapshotFile.parseId(this.file.getName()));
    }

    @VisibleForTesting
    static long parseId(String fileName) {
        int start = fileName.lastIndexOf(45, fileName.lastIndexOf(45, fileName.lastIndexOf(45) - 1) - 1) + 1;
        int end = fileName.lastIndexOf(45, fileName.lastIndexOf(45) - 1);
        String idString = fileName.substring(start, end);
        return Long.parseLong(idString);
    }

    public long index() {
        return SnapshotFile.parseIndex(this.file.getName());
    }

    @VisibleForTesting
    static long parseIndex(String fileName) {
        int start = fileName.lastIndexOf(45, fileName.lastIndexOf(45) - 1) + 1;
        int end = fileName.lastIndexOf(45);
        String indexString = fileName.substring(start, end);
        return Long.parseLong(indexString);
    }

    public long timestamp() {
        return SnapshotFile.parseTimestamp(this.file.getName());
    }

    @VisibleForTesting
    static long parseTimestamp(String fileName) {
        int start = fileName.lastIndexOf(45) + 1;
        int end = fileName.lastIndexOf(46);
        String timestampString = fileName.substring(start, end);
        SimpleDateFormat simpleDateFormat = TIMESTAMP_FORMAT;
        synchronized (simpleDateFormat) {
            try {
                Date timestamp = TIMESTAMP_FORMAT.parse(timestampString);
                return timestamp.getTime();
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

