/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.service.impl;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.operation.OperationId;
import io.atomix.protocols.raft.operation.OperationType;
import io.atomix.protocols.raft.service.Commit;
import io.atomix.protocols.raft.service.RaftService;
import io.atomix.protocols.raft.service.RaftServiceExecutor;
import io.atomix.protocols.raft.service.ServiceContext;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Function;
import org.slf4j.Logger;

public class DefaultRaftServiceExecutor
implements RaftServiceExecutor {
    private final Logger log;
    private final Queue<Runnable> tasks = new LinkedList<Runnable>();
    private final List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();
    private final List<ScheduledTask> complete = new ArrayList<ScheduledTask>();
    private final Map<OperationId, Function<Commit<byte[]>, byte[]>> operations = new HashMap<OperationId, Function<Commit<byte[]>, byte[]>>();
    private OperationType operationType;
    private long timestamp;

    public DefaultRaftServiceExecutor(ServiceContext context) {
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftService.class).addValue((Object)context.serviceId()).add("type", (Object)context.serviceType()).add("name", (Object)context.serviceName()).build());
    }

    private void prepareOperation(Commit<byte[]> commit) {
        long timestamp = commit.wallClockTime().unixTimestamp();
        if (commit.operation().type() == OperationType.COMMAND && !this.scheduledTasks.isEmpty()) {
            ScheduledTask task;
            Iterator<ScheduledTask> iterator = this.scheduledTasks.iterator();
            while (iterator.hasNext() && (task = iterator.next()).isRunnable(timestamp)) {
                this.timestamp = task.time;
                this.operationType = OperationType.COMMAND;
                this.log.trace("Executing scheduled task {}", (Object)task);
                task.execute();
                this.complete.add(task);
                iterator.remove();
            }
            for (ScheduledTask task2 : this.complete) {
                task2.reschedule(this.timestamp);
            }
            this.complete.clear();
        }
        this.operationType = commit.operation().type();
        this.timestamp = timestamp;
    }

    private void checkOperation(OperationType type, String message) {
        Preconditions.checkState((this.operationType == type ? 1 : 0) != 0, (Object)message);
    }

    @Override
    public void handle(OperationId operationId, Function<Commit<byte[]>, byte[]> callback) {
        Preconditions.checkNotNull((Object)operationId, (Object)"operationId cannot be null");
        Preconditions.checkNotNull(callback, (Object)"callback cannot be null");
        this.operations.put(operationId, callback);
        this.log.debug("Registered operation callback {}", (Object)operationId);
    }

    @Override
    public byte[] apply(Commit<byte[]> commit) {
        this.log.trace("Executing {}", commit);
        this.prepareOperation(commit);
        Function<Commit<byte[]>, byte[]> callback = this.operations.get(commit.operation());
        if (callback == null) {
            throw new IllegalStateException("Unknown state machine operation: " + commit.operation());
        }
        try {
            byte[] byArray = callback.apply(commit);
            return byArray;
        }
        catch (Exception e) {
            this.log.warn("State machine operation failed: {}", (Throwable)e);
            throw new RaftException.ApplicationException(e);
        }
        finally {
            this.runTasks();
        }
    }

    private void runTasks() {
        if (!this.tasks.isEmpty()) {
            for (Runnable task : this.tasks) {
                this.log.trace("Executing task {}", (Object)task);
                task.run();
            }
            this.tasks.clear();
        }
    }

    public void execute(Runnable callback) {
        this.checkOperation(OperationType.COMMAND, "callbacks can only be scheduled during command execution");
        this.tasks.add(callback);
    }

    public Scheduled schedule(Duration delay, Runnable callback) {
        this.checkOperation(OperationType.COMMAND, "callbacks can only be scheduled during command execution");
        this.log.trace("Scheduled callback {} with delay {}", (Object)callback, (Object)delay);
        return new ScheduledTask(callback, delay.toMillis()).schedule();
    }

    public Scheduled schedule(Duration initialDelay, Duration interval, Runnable callback) {
        this.checkOperation(OperationType.COMMAND, "callbacks can only be scheduled during command execution");
        this.log.trace("Scheduled repeating callback {} with initial delay {} and interval {}", new Object[]{callback, initialDelay, interval});
        return new ScheduledTask(callback, initialDelay.toMillis(), interval.toMillis()).schedule();
    }

    private class ScheduledTask
    implements Scheduled {
        private final long interval;
        private final Runnable callback;
        private long time;

        private ScheduledTask(Runnable callback, long delay) {
            this(callback, delay, 0L);
        }

        private ScheduledTask(Runnable callback, long delay, long interval) {
            this.interval = interval;
            this.callback = callback;
            this.time = DefaultRaftServiceExecutor.this.timestamp + delay;
        }

        private Scheduled schedule() {
            if (!DefaultRaftServiceExecutor.this.scheduledTasks.isEmpty()) {
                int i;
                int l = 0;
                int u = DefaultRaftServiceExecutor.this.scheduledTasks.size() - 1;
                while (true) {
                    i = (u + l) / 2;
                    long t = ((ScheduledTask)((DefaultRaftServiceExecutor)DefaultRaftServiceExecutor.this).scheduledTasks.get((int)i)).time;
                    if (t == this.time) {
                        DefaultRaftServiceExecutor.this.scheduledTasks.add(i, this);
                        return this;
                    }
                    if (t < this.time) {
                        l = i + 1;
                        if (l <= u) continue;
                        DefaultRaftServiceExecutor.this.scheduledTasks.add(i + 1, this);
                        return this;
                    }
                    u = i - 1;
                    if (l > u) break;
                }
                DefaultRaftServiceExecutor.this.scheduledTasks.add(i, this);
                return this;
            }
            DefaultRaftServiceExecutor.this.scheduledTasks.add(this);
            return this;
        }

        private void reschedule(long timestamp) {
            if (this.interval > 0L) {
                this.time = timestamp + this.interval;
                this.schedule();
            }
        }

        private boolean isRunnable(long timestamp) {
            return timestamp > this.time;
        }

        private synchronized void execute() {
            this.callback.run();
        }

        public synchronized void cancel() {
            DefaultRaftServiceExecutor.this.scheduledTasks.remove(this);
        }
    }
}

