/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.common.primitives.Longs;
import io.atomix.protocols.raft.RaftClient;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.proxy.RaftProxyClient;
import io.atomix.protocols.raft.proxy.impl.DiscreteRaftProxyClient;
import io.atomix.protocols.raft.proxy.impl.MemberSelectorManager;
import io.atomix.protocols.raft.proxy.impl.RaftProxyConnection;
import io.atomix.protocols.raft.proxy.impl.RaftProxyState;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.session.SessionId;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadPoolContext;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.time.Duration;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;

public class RaftProxyManager {
    private static final double TIMEOUT_FACTOR = 0.5;
    private static final long MIN_TIMEOUT_DELTA = 2500L;
    private final Logger log;
    private final String clientId;
    private final MemberId memberId;
    private final RaftClientProtocol protocol;
    private final RaftProxyConnection connection;
    private final ScheduledExecutorService threadPoolExecutor;
    private final MemberSelectorManager selectorManager;
    private final Map<Long, RaftProxyState> sessions = new ConcurrentHashMap<Long, RaftProxyState>();
    private final Map<Long, ScheduledFuture<?>> keepAliveFutures = new ConcurrentHashMap();
    private final AtomicBoolean open = new AtomicBoolean();

    public RaftProxyManager(String clientId, MemberId memberId, RaftClientProtocol protocol, MemberSelectorManager selectorManager, ScheduledExecutorService threadPoolExecutor) {
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"clientId cannot be null");
        this.memberId = (MemberId)Preconditions.checkNotNull((Object)memberId, (Object)"memberId cannot be null");
        this.protocol = (RaftClientProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.selectorManager = (MemberSelectorManager)Preconditions.checkNotNull((Object)selectorManager, (Object)"selectorManager cannot be null");
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftClient.class).addValue((Object)clientId).build());
        this.connection = new RaftProxyConnection(protocol, selectorManager.createSelector(CommunicationStrategy.ANY), (ThreadContext)new ThreadPoolContext(threadPoolExecutor), LoggerContext.builder(RaftClient.class).addValue((Object)clientId).build());
        this.threadPoolExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)threadPoolExecutor, (Object)"threadPoolExecutor cannot be null");
    }

    public void resetConnections() {
        this.selectorManager.resetAll();
    }

    public void resetConnections(MemberId leader, Collection<MemberId> servers) {
        this.selectorManager.resetAll(leader, servers);
    }

    public CompletableFuture<Void> open() {
        this.open.set(true);
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<RaftProxyClient> openSession(String serviceName, ServiceType serviceType, ReadConsistency readConsistency, CommunicationStrategy communicationStrategy, Duration timeout) {
        Preconditions.checkNotNull((Object)serviceName, (Object)"serviceName cannot be null");
        Preconditions.checkNotNull((Object)serviceType, (Object)"serviceType cannot be null");
        Preconditions.checkNotNull((Object)((Object)communicationStrategy), (Object)"communicationStrategy cannot be null");
        Preconditions.checkNotNull((Object)timeout, (Object)"timeout cannot be null");
        this.log.debug("Opening session; name: {}, type: {}", (Object)serviceName, (Object)serviceType);
        OpenSessionRequest request = OpenSessionRequest.newBuilder().withMemberId(this.memberId).withServiceName(serviceName).withServiceType(serviceType).withReadConsistency(readConsistency).withTimeout(timeout.toMillis()).build();
        CompletableFuture<RaftProxyClient> future = new CompletableFuture<RaftProxyClient>();
        ThreadPoolContext proxyContext = new ThreadPoolContext(this.threadPoolExecutor);
        this.connection.openSession(request).whenCompleteAsync((arg_0, arg_1) -> this.lambda$openSession$1(serviceName, serviceType, communicationStrategy, (ThreadContext)proxyContext, future, arg_0, arg_1), (Executor)proxyContext);
        return future;
    }

    public CompletableFuture<Void> closeSession(SessionId sessionId) {
        RaftProxyState state = this.sessions.get(sessionId.id());
        if (state == null) {
            return Futures.exceptionalFuture((Throwable)new RaftException.UnknownSession("Unknown session: " + (Object)((Object)sessionId), new Object[0]));
        }
        this.log.info("Closing session {}", (Object)sessionId);
        CloseSessionRequest request = ((CloseSessionRequest.Builder)CloseSessionRequest.newBuilder().withSession((Long)sessionId.id())).build();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.connection.closeSession(request).whenComplete((response, error) -> {
            if (error == null) {
                if (response.status() == RaftResponse.Status.OK) {
                    this.sessions.remove(sessionId.id());
                    future.complete(null);
                } else {
                    future.completeExceptionally(response.error().createException());
                }
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    CompletableFuture<Void> resetIndexes(SessionId sessionId) {
        RaftProxyState sessionState = this.sessions.get(sessionId.id());
        if (sessionState == null) {
            return Futures.exceptionalFuture((Throwable)new IllegalArgumentException("Unknown session: " + (Object)((Object)sessionId)));
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        KeepAliveRequest request = KeepAliveRequest.newBuilder().withSessionIds(new long[]{(Long)sessionId.id()}).withCommandSequences(new long[]{sessionState.getCommandResponse()}).withEventIndexes(new long[]{sessionState.getEventIndex()}).build();
        this.connection.keepAlive(request).whenComplete((response, error) -> {
            if (error == null) {
                if (response.status() == RaftResponse.Status.OK) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(response.error().createException());
                }
            } else {
                future.completeExceptionally((Throwable)error);
            }
        });
        return future;
    }

    private synchronized void keepAliveSessions(long lastKeepAliveTime, long sessionTimeout) {
        List needKeepAlive = this.sessions.values().stream().filter(session -> session.getSessionTimeout() == sessionTimeout).collect(Collectors.toList());
        if (needKeepAlive.isEmpty()) {
            return;
        }
        long[] sessionIds = new long[needKeepAlive.size()];
        long[] commandResponses = new long[needKeepAlive.size()];
        long[] eventIndexes = new long[needKeepAlive.size()];
        int i = 0;
        for (RaftProxyState sessionState : needKeepAlive) {
            sessionIds[i] = (Long)sessionState.getSessionId().id();
            commandResponses[i] = sessionState.getCommandResponse();
            eventIndexes[i] = sessionState.getEventIndex();
            ++i;
        }
        this.log.debug("Keeping {} sessions alive", (Object)sessionIds.length);
        KeepAliveRequest request = KeepAliveRequest.newBuilder().withSessionIds(sessionIds).withCommandSequences(commandResponses).withEventIndexes(eventIndexes).build();
        long keepAliveTime = System.currentTimeMillis();
        this.connection.keepAlive(request).whenComplete((response, error) -> {
            if (this.open.get()) {
                long delta = System.currentTimeMillis() - keepAliveTime;
                if (error == null) {
                    if (response.status() == RaftResponse.Status.OK) {
                        this.selectorManager.resetAll(response.leader(), response.members());
                        HashSet keptAliveSessions = Sets.newHashSet((Iterable)Longs.asList((long[])response.sessionIds()));
                        for (RaftProxyState session : needKeepAlive) {
                            if (keptAliveSessions.contains(session.getSessionId().id())) {
                                session.setState(RaftProxy.State.CONNECTED);
                                continue;
                            }
                            session.setState(RaftProxy.State.CLOSED);
                        }
                        this.scheduleKeepAlive(System.currentTimeMillis(), sessionTimeout, delta);
                    } else if (System.currentTimeMillis() - lastKeepAliveTime < sessionTimeout) {
                        this.selectorManager.resetAll(null, this.connection.servers());
                        this.keepAliveSessions(lastKeepAliveTime, sessionTimeout);
                    } else {
                        needKeepAlive.forEach(s -> s.setState(RaftProxy.State.SUSPENDED));
                        this.selectorManager.resetAll();
                        this.scheduleKeepAlive(lastKeepAliveTime, sessionTimeout, delta);
                    }
                } else if (System.currentTimeMillis() - lastKeepAliveTime < sessionTimeout && this.connection.leader() != null) {
                    this.selectorManager.resetAll(null, this.connection.servers());
                    this.keepAliveSessions(lastKeepAliveTime, sessionTimeout);
                } else {
                    needKeepAlive.forEach(s -> s.setState(RaftProxy.State.SUSPENDED));
                    this.selectorManager.resetAll();
                    this.scheduleKeepAlive(lastKeepAliveTime, sessionTimeout, delta);
                }
            }
        });
    }

    private synchronized void scheduleKeepAlive(long lastKeepAliveTime, long timeout, long delta) {
        ScheduledFuture<?> keepAliveFuture = this.keepAliveFutures.remove(timeout);
        if (keepAliveFuture != null) {
            keepAliveFuture.cancel(false);
        }
        this.keepAliveFutures.put(timeout, this.threadPoolExecutor.schedule(() -> {
            if (this.open.get()) {
                this.keepAliveSessions(lastKeepAliveTime, timeout);
            }
        }, Math.max(Math.max((long)((double)timeout * 0.5) - delta, timeout - 2500L - delta), 0L), TimeUnit.MILLISECONDS));
    }

    public CompletableFuture<Void> close() {
        if (this.open.compareAndSet(true, false)) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            this.threadPoolExecutor.execute(() -> {
                for (ScheduledFuture<?> keepAliveFuture : this.keepAliveFutures.values()) {
                    keepAliveFuture.cancel(false);
                }
                future.complete(null);
            });
            return future;
        }
        return CompletableFuture.completedFuture(null);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("client", (Object)this.clientId).toString();
    }

    private /* synthetic */ void lambda$openSession$1(String serviceName, ServiceType serviceType, CommunicationStrategy communicationStrategy, ThreadContext proxyContext, CompletableFuture future, OpenSessionResponse response, Throwable error) {
        if (error == null) {
            if (response.status() == RaftResponse.Status.OK) {
                RaftProxyState state = new RaftProxyState(this.clientId, SessionId.from(response.session()), serviceName, serviceType, response.timeout());
                this.sessions.put((Long)state.getSessionId().id(), state);
                state.addStateChangeListener(s -> {
                    if (s == RaftProxy.State.CLOSED) {
                        this.sessions.remove(state.getSessionId().id());
                    }
                });
                this.keepAliveSessions(System.currentTimeMillis(), state.getSessionTimeout());
                DiscreteRaftProxyClient client = new DiscreteRaftProxyClient(state, this.protocol, this.selectorManager, this, communicationStrategy, proxyContext);
                future.complete(client);
            } else {
                future.completeExceptionally(new RaftException.Unavailable(response.error().message(), new Object[0]));
            }
        } else {
            future.completeExceptionally(new RaftException.Unavailable(error.getMessage(), new Object[0]));
        }
    }
}

