/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.Throwables;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.operation.RaftOperation;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.proxy.RaftProxyClient;
import io.atomix.protocols.raft.proxy.impl.DelegatingRaftProxyClient;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.net.ConnectException;
import java.nio.channels.ClosedChannelException;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.slf4j.Logger;

public class RetryingRaftProxyClient
extends DelegatingRaftProxyClient {
    private final Logger log;
    private final RaftProxyClient client;
    private final Scheduler scheduler;
    private final int maxRetries;
    private final Duration delayBetweenRetries;
    private final Predicate<Throwable> retryableCheck = e -> e instanceof ConnectException || e instanceof TimeoutException || e instanceof ClosedChannelException || e instanceof RaftException.QueryFailure || e instanceof RaftException.UnknownClient || e instanceof RaftException.UnknownSession || e instanceof RaftException.ClosedSession || e instanceof RaftException.ProtocolException;

    public RetryingRaftProxyClient(RaftProxyClient delegate, Scheduler scheduler, int maxRetries, Duration delayBetweenRetries) {
        super(delegate);
        this.client = delegate;
        this.scheduler = scheduler;
        this.maxRetries = maxRetries;
        this.delayBetweenRetries = delayBetweenRetries;
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftProxy.class).addValue((Object)this.client.sessionId()).add("type", (Object)this.client.serviceType()).add("name", (Object)this.client.name()).build());
    }

    @Override
    public CompletableFuture<byte[]> execute(RaftOperation operation) {
        if (this.getState() == RaftProxy.State.CLOSED) {
            return Futures.exceptionalFuture((Throwable)new RaftException.Unavailable("Cluster is unavailable", new Object[0]));
        }
        CompletableFuture<byte[]> future = new CompletableFuture<byte[]>();
        this.execute(operation, 1, future);
        return future;
    }

    private void execute(RaftOperation operation, int attemptIndex, CompletableFuture<byte[]> future) {
        this.client.execute(operation).whenComplete((r, e) -> {
            if (e != null) {
                if (attemptIndex < this.maxRetries + 1 && this.retryableCheck.test(Throwables.getRootCause((Throwable)e))) {
                    this.log.debug("Retry attempt ({} of {}). Failure due to {}", new Object[]{attemptIndex, this.maxRetries, Throwables.getRootCause((Throwable)e).getClass()});
                    this.scheduleRetry(operation, attemptIndex, future);
                } else {
                    future.completeExceptionally((Throwable)e);
                }
            } else {
                future.complete((byte[])r);
            }
        });
    }

    private void scheduleRetry(RaftOperation operation, int attemptIndex, CompletableFuture<byte[]> future) {
        RaftProxy.State retryState = this.client.getState();
        this.scheduler.schedule(this.delayBetweenRetries.multipliedBy(2 ^ attemptIndex), () -> {
            if (retryState == RaftProxy.State.CONNECTED || this.client.getState() == RaftProxy.State.CONNECTED) {
                this.execute(operation, attemptIndex + 1, future);
            } else {
                this.scheduleRetry(operation, attemptIndex, future);
            }
        });
    }
}

