/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.session.SessionId;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

public final class RaftProxyState {
    private final String clientId;
    private final SessionId sessionId;
    private final String serviceName;
    private final ServiceType serviceType;
    private final long timeout;
    private volatile RaftProxy.State state = RaftProxy.State.CONNECTED;
    private volatile long commandRequest;
    private volatile long commandResponse;
    private volatile long responseIndex;
    private volatile long eventIndex;
    private final Set<Consumer<RaftProxy.State>> changeListeners = new CopyOnWriteArraySet<Consumer<RaftProxy.State>>();

    RaftProxyState(String clientId, SessionId sessionId, String serviceName, ServiceType serviceType, long timeout) {
        this.clientId = clientId;
        this.sessionId = sessionId;
        this.serviceName = serviceName;
        this.serviceType = serviceType;
        this.timeout = timeout;
        this.responseIndex = (Long)sessionId.id();
        this.eventIndex = (Long)sessionId.id();
    }

    public String getClientId() {
        return this.clientId;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public long getSessionTimeout() {
        return this.timeout;
    }

    public RaftProxy.State getState() {
        return this.state;
    }

    public void setState(RaftProxy.State state) {
        if (this.state != state) {
            this.state = state;
            this.changeListeners.forEach(l -> l.accept(state));
        }
    }

    public void addStateChangeListener(Consumer<RaftProxy.State> listener) {
        this.changeListeners.add((Consumer<RaftProxy.State>)Preconditions.checkNotNull(listener));
    }

    public void removeStateChangeListener(Consumer<RaftProxy.State> listener) {
        this.changeListeners.remove(Preconditions.checkNotNull(listener));
    }

    public void setCommandRequest(long commandRequest) {
        this.commandRequest = commandRequest;
    }

    public long getCommandRequest() {
        return this.commandRequest;
    }

    public long nextCommandRequest() {
        return ++this.commandRequest;
    }

    public void setCommandResponse(long commandResponse) {
        this.commandResponse = commandResponse;
    }

    public long getCommandResponse() {
        return this.commandResponse;
    }

    public void setResponseIndex(long responseIndex) {
        this.responseIndex = Math.max(this.responseIndex, responseIndex);
    }

    public long getResponseIndex() {
        return this.responseIndex;
    }

    public void setEventIndex(long eventIndex) {
        this.eventIndex = eventIndex;
    }

    public long getEventIndex() {
        return this.eventIndex;
    }
}

