/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy;

import io.atomix.protocols.raft.event.RaftEvent;
import io.atomix.protocols.raft.operation.OperationId;
import io.atomix.protocols.raft.operation.RaftOperation;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.session.SessionId;
import io.atomix.storage.buffer.HeapBytes;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public interface RaftProxyExecutor {
    public SessionId sessionId();

    public String name();

    public ServiceType serviceType();

    public RaftProxy.State getState();

    public void addStateChangeListener(Consumer<RaftProxy.State> var1);

    public void removeStateChangeListener(Consumer<RaftProxy.State> var1);

    default public CompletableFuture<byte[]> execute(OperationId operationId) {
        return this.execute(new RaftOperation(OperationId.simplify(operationId), HeapBytes.EMPTY));
    }

    default public CompletableFuture<byte[]> execute(OperationId operationId, byte[] operation) {
        return this.execute(new RaftOperation(OperationId.simplify(operationId), operation));
    }

    public CompletableFuture<byte[]> execute(RaftOperation var1);

    public void addEventListener(Consumer<RaftEvent> var1);

    public void removeEventListener(Consumer<RaftEvent> var1);
}

