/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.impl.MetadataResult;
import io.atomix.protocols.raft.impl.OperationResult;
import io.atomix.protocols.raft.impl.RaftContext;
import io.atomix.protocols.raft.service.RaftService;
import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.service.impl.DefaultServiceContext;
import io.atomix.protocols.raft.session.RaftSessionMetadata;
import io.atomix.protocols.raft.session.SessionId;
import io.atomix.protocols.raft.session.impl.RaftSessionContext;
import io.atomix.protocols.raft.storage.log.RaftLog;
import io.atomix.protocols.raft.storage.log.RaftLogReader;
import io.atomix.protocols.raft.storage.log.entry.CloseSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.CommandEntry;
import io.atomix.protocols.raft.storage.log.entry.ConfigurationEntry;
import io.atomix.protocols.raft.storage.log.entry.InitializeEntry;
import io.atomix.protocols.raft.storage.log.entry.KeepAliveEntry;
import io.atomix.protocols.raft.storage.log.entry.MetadataEntry;
import io.atomix.protocols.raft.storage.log.entry.OpenSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.QueryEntry;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotReader;
import io.atomix.storage.journal.Indexed;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.ThreadContextFactory;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class RaftServiceManager
implements AutoCloseable {
    private final Logger logger;
    private final RaftContext raft;
    private final ThreadContextFactory threadContextFactory;
    private final RaftLog log;
    private final RaftLogReader reader;
    private final Map<Long, CompletableFuture> futures = Maps.newHashMap();

    public RaftServiceManager(RaftContext raft, ThreadContextFactory threadContextFactory) {
        this.raft = (RaftContext)Preconditions.checkNotNull((Object)raft, (Object)"state cannot be null");
        this.log = raft.getLog();
        this.reader = this.log.openReader(1L, RaftLogReader.Mode.COMMITS);
        this.threadContextFactory = threadContextFactory;
        this.logger = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftServer.class).addValue((Object)raft.getName()).build());
    }

    public void applyAll(long index) {
        if (index > this.raft.getLastApplied()) {
            this.raft.getThreadContext().execute(() -> this.applyNext(index));
        }
    }

    public <T> CompletableFuture<T> apply(long index) {
        CompletableFuture future = this.futures.computeIfAbsent(index, i -> new CompletableFuture());
        this.raft.getThreadContext().execute(() -> this.applyNext(index));
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyNext(long index) {
        if (this.reader.hasNext()) {
            long lastApplied;
            long nextIndex = this.reader.getNextIndex();
            if (nextIndex > (lastApplied = this.raft.getLastApplied()) + 1L && nextIndex != this.reader.getFirstIndex()) {
                this.logger.error("Cannot apply non-sequential index {} unless it's the first entry in the log: {}", (Object)nextIndex, (Object)this.reader.getFirstIndex());
                CompletableFuture future = this.futures.remove(nextIndex);
                if (future != null) {
                    future.completeExceptionally(new IndexOutOfBoundsException("Cannot apply non-sequential index unless it's the first entry in the log"));
                }
                return;
            }
            if (nextIndex < lastApplied) {
                this.logger.error("Cannot apply duplicate entry at index {}", (Object)nextIndex);
                CompletableFuture future = this.futures.remove(nextIndex);
                if (future != null) {
                    future.completeExceptionally(new IndexOutOfBoundsException("Cannot apply duplicate entry at index " + nextIndex));
                }
                return;
            }
            if (nextIndex < index) {
                Indexed entry = this.reader.next();
                try {
                    this.restoreIndex(entry.index() - 1L);
                    this.apply((Indexed<? extends RaftLogEntry>)entry);
                }
                catch (Exception e2) {
                    this.logger.error("Failed to apply {}: {}", (Object)entry, (Object)e2);
                }
                finally {
                    this.raft.setLastApplied(nextIndex);
                }
                this.raft.getThreadContext().execute(() -> this.applyNext(index));
                return;
            }
            if (nextIndex == index) {
                Indexed entry = this.reader.next();
                try {
                    if (entry.index() != index) {
                        throw new IllegalStateException("inconsistent index applying entry " + index + ": " + entry);
                    }
                    this.restoreIndex(entry.index() - 1L);
                    CompletableFuture future = this.futures.remove(nextIndex);
                    this.apply((Indexed<? extends RaftLogEntry>)entry).whenComplete((r, e) -> {
                        if (future != null) {
                            if (e == null) {
                                future.complete(r);
                            } else {
                                future.completeExceptionally((Throwable)e);
                            }
                        }
                    });
                }
                catch (Exception e3) {
                    this.logger.error("Failed to apply {}: {}", (Object)entry, (Object)e3);
                }
                finally {
                    this.raft.setLastApplied(nextIndex);
                }
                return;
            }
            CompletableFuture future = this.futures.remove(nextIndex);
            if (future != null) {
                this.logger.warn("Skipped applying index {}", (Object)index);
                future.complete(null);
            }
            this.raft.setLastApplied(nextIndex);
            return;
        }
        CompletableFuture future = this.futures.remove(index);
        if (future != null) {
            this.logger.error("Cannot apply index " + index);
            future.completeExceptionally(new IndexOutOfBoundsException("Cannot apply index " + index));
        }
    }

    public <T> CompletableFuture<T> apply(Indexed<? extends RaftLogEntry> entry) {
        this.logger.trace("Applying {}", entry);
        if (entry.type() == QueryEntry.class) {
            return this.applyQuery((Indexed<QueryEntry>)entry.cast());
        }
        if (entry.type() == CommandEntry.class) {
            return this.applyCommand((Indexed<CommandEntry>)entry.cast());
        }
        if (entry.type() == OpenSessionEntry.class) {
            return this.applyOpenSession((Indexed<OpenSessionEntry>)entry.cast());
        }
        if (entry.type() == KeepAliveEntry.class) {
            return this.applyKeepAlive((Indexed<KeepAliveEntry>)entry.cast());
        }
        if (entry.type() == CloseSessionEntry.class) {
            return this.applyCloseSession((Indexed<CloseSessionEntry>)entry.cast());
        }
        if (entry.type() == MetadataEntry.class) {
            return this.applyMetadata((Indexed<MetadataEntry>)entry.cast());
        }
        if (entry.type() == InitializeEntry.class) {
            return this.applyInitialize((Indexed<InitializeEntry>)entry.cast());
        }
        if (entry.type() == ConfigurationEntry.class) {
            return this.applyConfiguration((Indexed<ConfigurationEntry>)entry.cast());
        }
        return Futures.exceptionalFuture((Throwable)new RaftException.ProtocolException("Unknown entry type", new Object[0]));
    }

    private void restoreIndex(long index) {
        Collection<Snapshot> snapshots = this.raft.getSnapshotStore().getSnapshotsByIndex(index);
        if (snapshots != null) {
            for (Snapshot snapshot : snapshots) {
                DefaultServiceContext service = null;
                try (SnapshotReader reader = snapshot.openReader();){
                    service = this.restoreService(reader);
                }
                if (service == null) continue;
                service.installSnapshot(index);
            }
        }
    }

    private DefaultServiceContext restoreService(SnapshotReader reader) {
        ServiceId serviceId = ServiceId.from(reader.readLong());
        ServiceType serviceType = ServiceType.from(reader.readString());
        String serviceName = reader.readString();
        this.logger.debug("Restoring service {} {}", (Object)serviceId, (Object)serviceName);
        DefaultServiceContext service = this.initializeService(serviceId, serviceType, serviceName);
        if (service == null) {
            return null;
        }
        this.restoreSessions(reader, service);
        return service;
    }

    private void restoreSessions(SnapshotReader reader, DefaultServiceContext service) {
        int sessionCount = reader.readInt();
        for (int i = 0; i < sessionCount; ++i) {
            this.restoreSession(reader, service);
        }
    }

    private void restoreSession(SnapshotReader reader, DefaultServiceContext service) {
        SessionId sessionId = SessionId.from(reader.readLong());
        this.logger.trace("Restoring session {} for {}", (Object)sessionId, (Object)service.serviceName());
        MemberId node = MemberId.from(reader.readString());
        ReadConsistency readConsistency = ReadConsistency.valueOf(reader.readString());
        long minTimeout = reader.readLong();
        long maxTimeout = reader.readLong();
        long sessionTimestamp = reader.readLong();
        RaftSessionContext session = new RaftSessionContext(sessionId, node, service.serviceName(), service.serviceType(), readConsistency, minTimeout, maxTimeout, sessionTimestamp, service, this.raft, this.threadContextFactory);
        session.setRequestSequence(reader.readLong());
        session.setCommandSequence(reader.readLong());
        session.setEventIndex(reader.readLong());
        session.setLastCompleted(reader.readLong());
        session.setLastApplied(reader.snapshot().index());
        this.raft.getSessions().addSession(session);
    }

    private CompletableFuture<Void> applyInitialize(Indexed<InitializeEntry> entry) {
        for (DefaultServiceContext service : this.raft.getServices()) {
            service.keepAliveSessions(entry.index(), ((InitializeEntry)entry.entry()).timestamp());
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> applyConfiguration(Indexed<ConfigurationEntry> entry) {
        for (DefaultServiceContext service : this.raft.getServices()) {
            service.keepAliveSessions(entry.index(), ((ConfigurationEntry)entry.entry()).timestamp());
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<long[]> applyKeepAlive(Indexed<KeepAliveEntry> entry) {
        long[] sessionIds = ((KeepAliveEntry)entry.entry()).sessionIds();
        long[] commandSequences = ((KeepAliveEntry)entry.entry()).commandSequenceNumbers();
        long[] eventIndexes = ((KeepAliveEntry)entry.entry()).eventIndexes();
        ArrayList successfulSessionIds = new ArrayList(sessionIds.length);
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(sessionIds.length);
        for (int i = 0; i < sessionIds.length; ++i) {
            long sessionId = sessionIds[i];
            long commandSequence = commandSequences[i];
            long eventIndex = eventIndexes[i];
            RaftSessionContext session = this.raft.getSessions().getSession(sessionId);
            if (session == null) continue;
            CompletionStage future = session.getService().keepAlive(entry.index(), ((KeepAliveEntry)entry.entry()).timestamp(), session, commandSequence, eventIndex).thenApply(succeeded -> {
                if (succeeded.booleanValue()) {
                    List list = successfulSessionIds;
                    synchronized (list) {
                        successfulSessionIds.add(sessionId);
                    }
                }
                return null;
            });
            futures.add(future);
        }
        for (DefaultServiceContext service : this.raft.getServices()) {
            service.completeKeepAlive(entry.index(), ((KeepAliveEntry)entry.entry()).timestamp());
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> {
            List list = successfulSessionIds;
            synchronized (list) {
                return Longs.toArray((Collection)successfulSessionIds);
            }
        });
    }

    private DefaultServiceContext getOrInitializeService(ServiceId serviceId, ServiceType serviceType, String serviceName) {
        DefaultServiceContext service = this.raft.getServices().getService(serviceName);
        if (service == null) {
            service = this.initializeService(serviceId, serviceType, serviceName);
        }
        return service;
    }

    private DefaultServiceContext initializeService(ServiceId serviceId, ServiceType serviceType, String serviceName) {
        Supplier<RaftService> serviceFactory = this.raft.getServiceFactories().getFactory((String)((Object)serviceType.id()));
        if (serviceFactory == null) {
            this.logger.warn("Unknown service type: {}", (Object)serviceType);
            return null;
        }
        DefaultServiceContext oldService = this.raft.getServices().getService(serviceName);
        DefaultServiceContext service = new DefaultServiceContext(serviceId, serviceName, serviceType, serviceFactory.get(), this.raft, this.threadContextFactory);
        this.raft.getServices().registerService(service);
        if (oldService != null) {
            this.raft.getSessions().removeSessions(oldService.serviceId());
        }
        return service;
    }

    private CompletableFuture<Long> applyOpenSession(Indexed<OpenSessionEntry> entry) {
        DefaultServiceContext service = this.getOrInitializeService(ServiceId.from(entry.index()), ServiceType.from(((OpenSessionEntry)entry.entry()).serviceType()), ((OpenSessionEntry)entry.entry()).serviceName());
        if (service == null) {
            return Futures.exceptionalFuture((Throwable)new RaftException.UnknownService("Unknown service type " + ((OpenSessionEntry)entry.entry()).serviceType(), new Object[0]));
        }
        SessionId sessionId = SessionId.from(entry.index());
        RaftSessionContext session = this.raft.getSessions().addSession(new RaftSessionContext(sessionId, MemberId.from(((OpenSessionEntry)entry.entry()).memberId()), ((OpenSessionEntry)entry.entry()).serviceName(), ServiceType.from(((OpenSessionEntry)entry.entry()).serviceType()), ((OpenSessionEntry)entry.entry()).readConsistency(), ((OpenSessionEntry)entry.entry()).minTimeout(), ((OpenSessionEntry)entry.entry()).maxTimeout(), ((OpenSessionEntry)entry.entry()).timestamp(), service, this.raft, this.threadContextFactory));
        return service.openSession(entry.index(), ((OpenSessionEntry)entry.entry()).timestamp(), session);
    }

    private CompletableFuture<Void> applyCloseSession(Indexed<CloseSessionEntry> entry) {
        RaftSessionContext session = this.raft.getSessions().getSession(((CloseSessionEntry)entry.entry()).session());
        if (session == null) {
            return Futures.exceptionalFuture((Throwable)new RaftException.UnknownSession("Unknown session: " + ((CloseSessionEntry)entry.entry()).session(), new Object[0]));
        }
        DefaultServiceContext service = session.getService();
        return service.closeSession(entry.index(), ((CloseSessionEntry)entry.entry()).timestamp(), session, ((CloseSessionEntry)entry.entry()).expired());
    }

    private CompletableFuture<MetadataResult> applyMetadata(Indexed<MetadataEntry> entry) {
        if (((MetadataEntry)entry.entry()).session() > 0L) {
            RaftSessionContext session = this.raft.getSessions().getSession(((MetadataEntry)entry.entry()).session());
            if (session == null) {
                this.logger.warn("Unknown session: " + ((MetadataEntry)entry.entry()).session());
                return Futures.exceptionalFuture((Throwable)new RaftException.UnknownSession("Unknown session: " + ((MetadataEntry)entry.entry()).session(), new Object[0]));
            }
            HashSet<RaftSessionMetadata> sessions = new HashSet<RaftSessionMetadata>();
            for (RaftSessionContext s : this.raft.getSessions().getSessions()) {
                if (!s.serviceName().equals(session.serviceName())) continue;
                sessions.add(new RaftSessionMetadata((Long)s.sessionId().id(), s.serviceName(), (String)((Object)s.serviceType().id())));
            }
            return CompletableFuture.completedFuture(new MetadataResult(sessions));
        }
        HashSet<RaftSessionMetadata> sessions = new HashSet<RaftSessionMetadata>();
        for (RaftSessionContext session : this.raft.getSessions().getSessions()) {
            sessions.add(new RaftSessionMetadata((Long)session.sessionId().id(), session.serviceName(), (String)((Object)session.serviceType().id())));
        }
        return CompletableFuture.completedFuture(new MetadataResult(sessions));
    }

    private CompletableFuture<OperationResult> applyCommand(Indexed<CommandEntry> entry) {
        RaftSessionContext session = this.raft.getSessions().getSession(((CommandEntry)entry.entry()).session());
        if (session == null) {
            this.logger.debug("Unknown session: " + ((CommandEntry)entry.entry()).session());
            return Futures.exceptionalFuture((Throwable)new RaftException.UnknownSession("unknown session: " + ((CommandEntry)entry.entry()).session(), new Object[0]));
        }
        this.raft.getLoadMonitor().recordEvent();
        return session.getService().executeCommand(entry.index(), ((CommandEntry)entry.entry()).sequenceNumber(), ((CommandEntry)entry.entry()).timestamp(), session, ((CommandEntry)entry.entry()).operation());
    }

    private CompletableFuture<OperationResult> applyQuery(Indexed<QueryEntry> entry) {
        RaftSessionContext session = this.raft.getSessions().getSession(((QueryEntry)entry.entry()).session());
        if (session == null) {
            this.logger.warn("Unknown session: " + ((QueryEntry)entry.entry()).session());
            return Futures.exceptionalFuture((Throwable)new RaftException.UnknownSession("unknown session " + ((QueryEntry)entry.entry()).session(), new Object[0]));
        }
        return session.getService().executeQuery(entry.index(), ((QueryEntry)entry.entry()).sequenceNumber(), ((QueryEntry)entry.entry()).timestamp(), session, ((QueryEntry)entry.entry()).operation());
    }

    @Override
    public void close() {
    }
}

