/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.session.impl;

import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.session.SessionId;
import io.atomix.protocols.raft.session.impl.RaftSessionContext;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class RaftSessionRegistry {
    private final Map<Long, RaftSessionContext> sessions = new ConcurrentHashMap<Long, RaftSessionContext>();

    public void addSession(RaftSessionContext session) {
        this.sessions.putIfAbsent((Long)session.sessionId().id(), session);
    }

    public void removeSession(SessionId sessionId) {
        this.sessions.remove(sessionId.id());
    }

    public RaftSessionContext getSession(SessionId sessionId) {
        return this.getSession((Long)sessionId.id());
    }

    public RaftSessionContext getSession(long sessionId) {
        return this.sessions.get(sessionId);
    }

    public Collection<RaftSessionContext> getSessions() {
        return this.sessions.values();
    }

    public Collection<RaftSessionContext> getSessions(ServiceId serviceId) {
        return this.sessions.values().stream().filter(session -> session.getService().serviceId().equals((Object)serviceId)).filter(session -> session.getState().active()).collect(Collectors.toSet());
    }

    public void removeSessions(ServiceId serviceId) {
        this.sessions.entrySet().removeIf(e -> ((RaftSessionContext)e.getValue()).getService().serviceId().equals((Object)serviceId));
    }
}

