/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.log.entry;

import com.google.common.base.MoreObjects;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.storage.log.entry.TimestampedEntry;
import io.atomix.utils.TimestampPrinter;

public class OpenSessionEntry
extends TimestampedEntry {
    private final String memberId;
    private final String serviceName;
    private final String serviceType;
    private final ReadConsistency readConsistency;
    private final long minTimeout;
    private final long maxTimeout;

    public OpenSessionEntry(long term, long timestamp, String memberId, String serviceName, String serviceType, ReadConsistency readConsistency, long minTimeout, long maxTimeout) {
        super(term, timestamp);
        this.memberId = memberId;
        this.serviceName = serviceName;
        this.serviceType = serviceType;
        this.readConsistency = readConsistency;
        this.minTimeout = minTimeout;
        this.maxTimeout = maxTimeout;
    }

    public String memberId() {
        return this.memberId;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String serviceType() {
        return this.serviceType;
    }

    public ReadConsistency readConsistency() {
        return this.readConsistency;
    }

    public long minTimeout() {
        return this.minTimeout;
    }

    public long maxTimeout() {
        return this.maxTimeout;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("timestamp", (Object)new TimestampPrinter(this.timestamp)).add("node", (Object)this.memberId).add("serviceName", (Object)this.serviceName).add("serviceType", (Object)this.serviceType).add("readConsistency", (Object)this.readConsistency).add("minTimeout", this.minTimeout).add("maxTimeout", this.maxTimeout).toString();
    }
}

