/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.service.impl;

import io.atomix.protocols.raft.session.RaftSession;
import io.atomix.protocols.raft.session.RaftSessionListener;
import io.atomix.protocols.raft.session.RaftSessions;
import io.atomix.protocols.raft.session.impl.RaftSessionContext;
import io.atomix.protocols.raft.session.impl.RaftSessionManager;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class DefaultServiceSessions
implements RaftSessions {
    private final RaftSessionManager sessionManager;
    private final Map<Long, RaftSessionContext> sessions = new ConcurrentHashMap<Long, RaftSessionContext>();
    private final Set<RaftSessionListener> listeners = new HashSet<RaftSessionListener>();

    DefaultServiceSessions(RaftSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    void add(RaftSessionContext session) {
        this.sessions.put((Long)session.sessionId().id(), session);
        this.sessionManager.registerSession(session);
    }

    void remove(RaftSessionContext session) {
        this.sessions.remove(session.sessionId().id());
        this.sessionManager.unregisterSession((Long)session.sessionId().id());
    }

    void clear() {
        this.sessions.values().forEach(session -> this.sessionManager.unregisterSession((Long)session.sessionId().id()));
        this.sessions.clear();
    }

    Collection<RaftSessionContext> getSessions() {
        return this.sessions.values();
    }

    @Override
    public RaftSession getSession(long sessionId) {
        return this.sessions.get(sessionId);
    }

    @Override
    public RaftSessions addListener(RaftSessionListener listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public RaftSessions removeListener(RaftSessionListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    Collection<RaftSessionListener> getListeners() {
        return this.listeners;
    }

    @Override
    public Iterator<RaftSession> iterator() {
        return this.sessions.values().iterator();
    }
}

