/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy.impl;

import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import io.atomix.protocols.raft.proxy.impl.MemberSelector;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public final class MemberSelectorManager {
    private final Set<MemberSelector> selectors = new CopyOnWriteArraySet<MemberSelector>();
    private volatile MemberId leader;
    private volatile Collection<MemberId> servers = Collections.emptyList();

    public MemberId leader() {
        return this.leader;
    }

    public Collection<MemberId> servers() {
        return this.servers;
    }

    public MemberSelector createSelector(CommunicationStrategy selectionStrategy) {
        MemberSelector selector = new MemberSelector(this.leader, this.servers, selectionStrategy, this);
        this.selectors.add(selector);
        return selector;
    }

    public void resetAll() {
        this.selectors.forEach(MemberSelector::reset);
    }

    public void resetAll(MemberId leader, Collection<MemberId> servers) {
        this.leader = leader;
        this.servers = new LinkedList<MemberId>(servers);
        this.selectors.forEach(s -> s.reset(leader, servers));
    }

    void remove(MemberSelector selector) {
        this.selectors.remove(selector);
    }
}

