/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftClient;
import io.atomix.protocols.raft.RaftMetadataClient;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.impl.DefaultRaftMetadataClient;
import io.atomix.protocols.raft.protocol.RaftClientProtocol;
import io.atomix.protocols.raft.proxy.RaftProxy;
import io.atomix.protocols.raft.proxy.RaftProxyClient;
import io.atomix.protocols.raft.proxy.RecoveryStrategy;
import io.atomix.protocols.raft.proxy.impl.BlockingAwareRaftProxyClient;
import io.atomix.protocols.raft.proxy.impl.DelegatingRaftProxy;
import io.atomix.protocols.raft.proxy.impl.MemberSelectorManager;
import io.atomix.protocols.raft.proxy.impl.RaftProxyManager;
import io.atomix.protocols.raft.proxy.impl.RecoveringRaftProxyClient;
import io.atomix.protocols.raft.proxy.impl.RetryingRaftProxyClient;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadPoolContext;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.logging.ContextualLogger;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;

public class DefaultRaftClient
implements RaftClient {
    private final String clientId;
    private final Collection<MemberId> cluster;
    private final ScheduledExecutorService threadPoolExecutor;
    private final RaftMetadataClient metadata;
    private final MemberSelectorManager selectorManager = new MemberSelectorManager();
    private final RaftProxyManager sessionManager;

    public DefaultRaftClient(String clientId, MemberId nodeId, Collection<MemberId> cluster, RaftClientProtocol protocol, ScheduledExecutorService threadPoolExecutor) {
        this.clientId = (String)Preconditions.checkNotNull((Object)clientId, (Object)"clientId cannot be null");
        this.cluster = (Collection)Preconditions.checkNotNull(cluster, (Object)"cluster cannot be null");
        this.threadPoolExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)threadPoolExecutor, (Object)"threadPoolExecutor cannot be null");
        this.metadata = new DefaultRaftMetadataClient(clientId, protocol, this.selectorManager, (ThreadContext)new ThreadPoolContext(threadPoolExecutor));
        this.sessionManager = new RaftProxyManager(clientId, nodeId, protocol, this.selectorManager, threadPoolExecutor);
    }

    @Override
    public String clientId() {
        return this.clientId;
    }

    @Override
    public RaftMetadataClient metadata() {
        return this.metadata;
    }

    @Override
    public synchronized CompletableFuture<RaftClient> connect(Collection<MemberId> cluster) {
        CompletableFuture<RaftClient> future = new CompletableFuture<RaftClient>();
        if (cluster == null || cluster.isEmpty()) {
            cluster = this.cluster;
        }
        if (cluster == null || cluster.isEmpty()) {
            throw new IllegalArgumentException("No cluster specified");
        }
        this.sessionManager.resetConnections(null, cluster);
        this.sessionManager.open().whenCompleteAsync((result, error) -> {
            if (error == null) {
                future.complete(this);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }, (Executor)this.threadPoolExecutor);
        return future;
    }

    @Override
    public RaftProxy.Builder newProxyBuilder() {
        return new SessionBuilder();
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return this.sessionManager.close().thenRunAsync(this.threadPoolExecutor::shutdownNow);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.clientId).toString();
    }

    public static class Builder
    extends RaftClient.Builder {
        public Builder(Collection<MemberId> cluster) {
            super(cluster);
        }

        public RaftClient build() {
            Preconditions.checkNotNull((Object)this.nodeId, (Object)"nodeId cannot be null");
            ContextualLogger log = ContextualLoggerFactory.getLogger(DefaultRaftClient.class, (LoggerContext)LoggerContext.builder(RaftClient.class).addValue((Object)this.clientId).build());
            ThreadFactory threadFactory = Threads.namedThreads((String)("raft-client-" + this.clientId + "-%d"), (Logger)log);
            ScheduledExecutorService executor = Executors.newScheduledThreadPool(this.threadPoolSize, threadFactory);
            return new DefaultRaftClient(this.clientId, this.nodeId, this.cluster, this.protocol, executor);
        }
    }

    private class SessionBuilder
    extends RaftProxy.Builder {
        private SessionBuilder() {
        }

        public RaftProxy build() {
            RaftProxyClient.Builder clientBuilder = new RaftProxyClient.Builder(){

                @Override
                public CompletableFuture<RaftProxyClient> buildAsync() {
                    return DefaultRaftClient.this.sessionManager.openSession(this.name, this.serviceType, this.readConsistency, this.communicationStrategy, this.timeout);
                }
            };
            clientBuilder.withName(this.name).withServiceType(this.serviceType).withReadConsistency(this.readConsistency).withMaxRetries(this.maxRetries).withRetryDelay(this.retryDelay).withCommunicationStrategy(this.communicationStrategy).withRecoveryStrategy(this.recoveryStrategy).withTimeout(this.timeout);
            RaftProxyClient client = this.recoveryStrategy == RecoveryStrategy.RECOVER ? new RecoveringRaftProxyClient(DefaultRaftClient.this.clientId, this.name, this.serviceType, clientBuilder, (Scheduler)new ThreadPoolContext(DefaultRaftClient.this.threadPoolExecutor)) : clientBuilder.build();
            if (this.maxRetries > 0) {
                client = new RetryingRaftProxyClient(client, (Scheduler)new ThreadPoolContext(DefaultRaftClient.this.threadPoolExecutor), this.maxRetries, this.retryDelay);
            }
            Executor executor = this.executor != null ? this.executor : new ThreadPoolContext(DefaultRaftClient.this.threadPoolExecutor);
            client = new BlockingAwareRaftProxyClient(client, executor);
            return new DelegatingRaftProxy(client);
        }
    }
}

