/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.proxy;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.proxy.CommunicationStrategy;
import io.atomix.protocols.raft.proxy.RaftProxyExecutor;
import io.atomix.protocols.raft.proxy.RecoveryStrategy;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.utils.Managed;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public interface RaftProxyClient
extends RaftProxyExecutor,
Managed<RaftProxyClient> {

    public static abstract class Builder
    implements io.atomix.utils.Builder<RaftProxyClient> {
        protected String name;
        protected ServiceType serviceType;
        protected ReadConsistency readConsistency = ReadConsistency.LINEARIZABLE;
        protected int maxRetries = 0;
        protected Duration retryDelay = Duration.ofMillis(100L);
        protected Executor executor;
        protected CommunicationStrategy communicationStrategy = CommunicationStrategy.LEADER;
        protected RecoveryStrategy recoveryStrategy = RecoveryStrategy.RECOVER;
        protected Duration timeout = Duration.ofMillis(0L);

        public Builder withName(String name) {
            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
            return this;
        }

        public Builder withServiceType(String serviceType) {
            return this.withServiceType(ServiceType.from(serviceType));
        }

        public Builder withServiceType(ServiceType serviceType) {
            this.serviceType = (ServiceType)Preconditions.checkNotNull((Object)serviceType, (Object)"serviceType cannot be null");
            return this;
        }

        public Builder withReadConsistency(ReadConsistency consistency) {
            this.readConsistency = (ReadConsistency)((Object)Preconditions.checkNotNull((Object)((Object)consistency), (Object)"consistency cannot be null"));
            return this;
        }

        public Builder withCommunicationStrategy(CommunicationStrategy communicationStrategy) {
            this.communicationStrategy = (CommunicationStrategy)((Object)Preconditions.checkNotNull((Object)((Object)communicationStrategy), (Object)"communicationStrategy"));
            return this;
        }

        public Builder withMaxRetries(int maxRetries) {
            Preconditions.checkArgument((maxRetries >= 0 ? 1 : 0) != 0, (Object)"maxRetries must be positive");
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder withRetryDelayMillis(long retryDelayMillis) {
            return this.withRetryDelay(Duration.ofMillis(retryDelayMillis));
        }

        public Builder withRetryDelay(long retryDelay, TimeUnit timeUnit) {
            return this.withRetryDelay(Duration.ofMillis(timeUnit.toMillis(retryDelay)));
        }

        public Builder withRetryDelay(Duration retryDelay) {
            this.retryDelay = (Duration)Preconditions.checkNotNull((Object)retryDelay, (Object)"retryDelay cannot be null");
            return this;
        }

        public Builder withRecoveryStrategy(RecoveryStrategy recoveryStrategy) {
            this.recoveryStrategy = (RecoveryStrategy)((Object)Preconditions.checkNotNull((Object)((Object)recoveryStrategy), (Object)"recoveryStrategy cannot be null"));
            return this;
        }

        public Builder withTimeout(long timeoutMillis) {
            return this.withTimeout(Duration.ofMillis(timeoutMillis));
        }

        public Builder withTimeout(Duration timeout) {
            Preconditions.checkArgument((!((Duration)Preconditions.checkNotNull((Object)timeout)).isNegative() ? 1 : 0) != 0, (Object)"timeout must be positive");
            this.timeout = timeout;
            return this;
        }

        public RaftProxyClient build() {
            try {
                return this.buildAsync().join();
            }
            catch (CompletionException e) {
                if (e.getCause() instanceof RaftException.Unavailable) {
                    throw (RaftException.Unavailable)e.getCause();
                }
                throw new RaftException.Unavailable(e);
            }
        }

        public abstract CompletableFuture<RaftProxyClient> buildAsync();
    }
}

