/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.snapshot;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotDescriptor;
import io.atomix.protocols.raft.storage.snapshot.SnapshotFile;
import io.atomix.protocols.raft.storage.snapshot.SnapshotReader;
import io.atomix.protocols.raft.storage.snapshot.SnapshotStore;
import io.atomix.protocols.raft.storage.snapshot.SnapshotWriter;
import io.atomix.storage.buffer.Buffer;
import io.atomix.storage.buffer.FileBuffer;
import io.atomix.time.WallClockTimestamp;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

final class FileSnapshot
extends Snapshot {
    private final SnapshotFile file;
    private final SnapshotStore store;

    FileSnapshot(SnapshotFile file, SnapshotStore store) {
        super(store);
        this.file = (SnapshotFile)Preconditions.checkNotNull((Object)file, (Object)"file cannot be null");
        this.store = (SnapshotStore)Preconditions.checkNotNull((Object)store, (Object)"store cannot be null");
    }

    @Override
    public ServiceId serviceId() {
        return this.file.snapshotId();
    }

    @Override
    public long index() {
        return this.file.index();
    }

    @Override
    public WallClockTimestamp timestamp() {
        return WallClockTimestamp.from((long)this.file.timestamp());
    }

    @Override
    public synchronized SnapshotWriter openWriter() {
        this.checkWriter();
        SnapshotDescriptor descriptor = SnapshotDescriptor.newBuilder().withIndex(this.file.index()).withTimestamp(this.file.timestamp()).build();
        FileBuffer buffer = FileBuffer.allocate((File)this.file.file(), (int)64);
        descriptor.copyTo((Buffer)buffer);
        int length = buffer.position(64).readInt();
        return this.openWriter(new SnapshotWriter(buffer.skip(length).mark(), this), descriptor);
    }

    @Override
    protected void closeWriter(SnapshotWriter writer) {
        int length = writer.buffer.position() - 68;
        writer.buffer.writeInt(64, length).flush();
        super.closeWriter(writer);
    }

    @Override
    public synchronized SnapshotReader openReader() {
        Preconditions.checkState((boolean)this.file.file().exists(), (String)"missing snapshot file: %s", (Object)this.file.file());
        FileBuffer buffer = FileBuffer.allocate((File)this.file.file(), (int)64);
        SnapshotDescriptor descriptor = new SnapshotDescriptor((Buffer)buffer);
        int length = buffer.position(64).readInt();
        return this.openReader(new SnapshotReader(buffer.mark().limit(68 + length), this), descriptor);
    }

    @Override
    public boolean isPersisted() {
        return true;
    }

    @Override
    public Snapshot complete() {
        FileBuffer buffer = FileBuffer.allocate((File)this.file.file(), (int)64);
        try (SnapshotDescriptor descriptor = new SnapshotDescriptor((Buffer)buffer);){
            Preconditions.checkState((!descriptor.isLocked() ? 1 : 0) != 0, (Object)"cannot complete locked snapshot descriptor");
            descriptor.lock();
        }
        return super.complete();
    }

    @Override
    public void delete() {
        Path path = this.file.file().toPath();
        if (Files.exists(path, new LinkOption[0])) {
            try {
                Files.delete(this.file.file().toPath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", this.index()).toString();
    }
}

