/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.log.entry;

import com.google.common.base.MoreObjects;
import io.atomix.protocols.raft.storage.log.entry.TimestampedEntry;
import io.atomix.utils.ArraySizeHashPrinter;
import io.atomix.utils.TimestampPrinter;
import java.util.Arrays;

public class KeepAliveEntry
extends TimestampedEntry {
    private final long[] sessionIds;
    private final long[] commandSequences;
    private final long[] eventIndexes;

    public KeepAliveEntry(long term, long timestamp, long[] sessionIds, long[] commandSequences, long[] eventIndexes) {
        super(term, timestamp);
        this.sessionIds = sessionIds;
        this.commandSequences = commandSequences;
        this.eventIndexes = eventIndexes;
    }

    public long[] sessionIds() {
        return this.sessionIds;
    }

    public long[] commandSequenceNumbers() {
        return this.commandSequences;
    }

    public long[] eventIndexes() {
        return this.eventIndexes;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("timestamp", (Object)new TimestampPrinter(this.timestamp)).add("sessionIds", (Object)Arrays.toString(this.sessionIds)).add("commandSequences", (Object)ArraySizeHashPrinter.of((long[])this.commandSequences)).add("eventIndexes", (Object)ArraySizeHashPrinter.of((long[])this.eventIndexes)).toString();
    }
}

