/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.log;

import io.atomix.protocols.raft.storage.log.RaftLog;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.storage.journal.DelegatingJournalWriter;
import io.atomix.storage.journal.JournalWriter;

public class RaftLogWriter
extends DelegatingJournalWriter<RaftLogEntry> {
    private final RaftLog log;

    public RaftLogWriter(JournalWriter<RaftLogEntry> delegate, RaftLog log) {
        super(delegate);
        this.log = log;
    }

    public void commit(long index) {
        if (index > this.log.getCommitIndex()) {
            this.log.setCommitIndex(index);
            if (this.log.isFlushOnCommit()) {
                this.flush();
            }
        }
    }

    public void truncate(long index) {
        if (index < this.log.getCommitIndex()) {
            throw new IndexOutOfBoundsException("Cannot truncate committed index: " + index);
        }
        super.truncate(index);
    }
}

