/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.log;

import io.atomix.protocols.raft.storage.log.RaftLog;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.storage.journal.DelegatingJournalReader;
import io.atomix.storage.journal.JournalReader;

public class RaftLogReader
extends DelegatingJournalReader<RaftLogEntry> {
    private final RaftLog log;
    private final Mode mode;

    public RaftLogReader(JournalReader<RaftLogEntry> delegate, RaftLog log, Mode mode) {
        super(delegate);
        this.log = log;
        this.mode = mode;
    }

    public boolean hasNext() {
        long commitIndex;
        if (this.mode == Mode.ALL) {
            return super.hasNext();
        }
        long nextIndex = this.getNextIndex();
        return nextIndex <= (commitIndex = this.log.getCommitIndex()) && super.hasNext();
    }

    public static enum Mode {
        ALL,
        COMMITS;

    }
}

