/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.storage.log;

import io.atomix.protocols.raft.storage.log.RaftLogReader;
import io.atomix.protocols.raft.storage.log.RaftLogWriter;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.serializer.Serializer;
import io.atomix.storage.StorageLevel;
import io.atomix.storage.journal.DelegatingJournal;
import io.atomix.storage.journal.Journal;
import io.atomix.storage.journal.JournalReader;
import io.atomix.storage.journal.JournalWriter;
import io.atomix.storage.journal.SegmentedJournal;
import java.io.File;

public class RaftLog
extends DelegatingJournal<RaftLogEntry> {
    private final Journal<RaftLogEntry> delegate;
    private final boolean flushOnCommit;
    private final RaftLogWriter writer;
    private volatile long commitIndex;

    public static Builder builder() {
        return new Builder();
    }

    public RaftLog(Journal<RaftLogEntry> delegate, boolean flushOnCommit) {
        super(delegate);
        this.delegate = delegate;
        this.flushOnCommit = flushOnCommit;
        this.writer = new RaftLogWriter((JournalWriter<RaftLogEntry>)delegate.writer(), this);
    }

    public RaftLogWriter writer() {
        return this.writer;
    }

    public RaftLogReader openReader(long index) {
        return this.openReader(index, RaftLogReader.Mode.ALL);
    }

    public RaftLogReader openReader(long index, RaftLogReader.Mode mode) {
        return new RaftLogReader((JournalReader<RaftLogEntry>)this.delegate.openReader(index), this, mode);
    }

    boolean isFlushOnCommit() {
        return this.flushOnCommit;
    }

    void setCommitIndex(long index) {
        this.commitIndex = index;
    }

    long getCommitIndex() {
        return this.commitIndex;
    }

    public static class Builder
    implements io.atomix.utils.Builder<RaftLog> {
        private static final boolean DEFAULT_FLUSH_ON_COMMIT = false;
        private final SegmentedJournal.Builder<RaftLogEntry> journalBuilder = SegmentedJournal.newBuilder();
        private boolean flushOnCommit = false;

        protected Builder() {
        }

        public Builder withName(String name) {
            this.journalBuilder.withName(name);
            return this;
        }

        public Builder withStorageLevel(StorageLevel storageLevel) {
            this.journalBuilder.withStorageLevel(storageLevel);
            return this;
        }

        public Builder withDirectory(String directory) {
            this.journalBuilder.withDirectory(directory);
            return this;
        }

        public Builder withDirectory(File directory) {
            this.journalBuilder.withDirectory(directory);
            return this;
        }

        public Builder withSerializer(Serializer serializer) {
            this.journalBuilder.withSerializer(serializer);
            return this;
        }

        public Builder withMaxSegmentSize(int maxSegmentSize) {
            this.journalBuilder.withMaxSegmentSize(maxSegmentSize);
            return this;
        }

        public Builder withMaxEntriesPerSegment(int maxEntriesPerSegment) {
            this.journalBuilder.withMaxEntriesPerSegment(maxEntriesPerSegment);
            return this;
        }

        public Builder withFlushOnCommit() {
            return this.withFlushOnCommit(true);
        }

        public Builder withFlushOnCommit(boolean flushOnCommit) {
            this.flushOnCommit = flushOnCommit;
            return this;
        }

        public RaftLog build() {
            return new RaftLog((Journal<RaftLogEntry>)this.journalBuilder.build(), this.flushOnCommit);
        }
    }
}

