/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.service;

import io.atomix.protocols.raft.service.Commit;
import io.atomix.protocols.raft.service.RaftService;
import io.atomix.protocols.raft.service.RaftServiceExecutor;
import io.atomix.protocols.raft.service.ServiceContext;
import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.service.impl.DefaultRaftServiceExecutor;
import io.atomix.protocols.raft.session.RaftSession;
import io.atomix.protocols.raft.session.RaftSessions;
import io.atomix.time.LogicalClock;
import io.atomix.time.WallClock;
import io.atomix.utils.concurrent.Scheduler;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import org.slf4j.Logger;

public abstract class AbstractRaftService
implements RaftService {
    private Logger log;
    private ServiceContext context;
    private RaftServiceExecutor executor;

    @Override
    public void init(ServiceContext context) {
        this.context = context;
        this.executor = new DefaultRaftServiceExecutor(context);
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftService.class).addValue((Object)context.serviceId()).add("type", (Object)context.serviceType()).add("name", (Object)context.serviceName()).build());
        this.configure(this.executor);
    }

    @Override
    public byte[] apply(Commit<byte[]> commit) {
        return this.executor.apply(commit);
    }

    protected abstract void configure(RaftServiceExecutor var1);

    protected ServiceContext getContext() {
        return this.context;
    }

    protected Logger getLogger() {
        return this.log;
    }

    protected Scheduler getScheduler() {
        return this.executor;
    }

    protected ServiceId getStateMachineId() {
        return this.context.serviceId();
    }

    protected String getName() {
        return this.context.serviceName();
    }

    protected long getCurrentIndex() {
        return this.context.currentIndex();
    }

    protected WallClock getWallClock() {
        return this.context.wallClock();
    }

    protected LogicalClock getLogicalClock() {
        return this.context.logicalClock();
    }

    protected RaftSessions getSessions() {
        return this.context.sessions();
    }

    @Override
    public void onOpen(RaftSession session) {
    }

    @Override
    public void onExpire(RaftSession session) {
    }

    @Override
    public void onClose(RaftSession session) {
    }
}

