/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.ReadConsistency;
import io.atomix.protocols.raft.impl.OperationResult;
import io.atomix.protocols.raft.impl.RaftServerContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.OperationResponse;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.roles.RaftRole;
import io.atomix.protocols.raft.roles.ReserveRole;
import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.session.impl.RaftSessionContext;
import io.atomix.protocols.raft.storage.log.RaftLogWriter;
import io.atomix.protocols.raft.storage.log.entry.QueryEntry;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotWriter;
import io.atomix.storage.journal.Indexed;
import io.atomix.time.WallClockTimestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

public class PassiveRole
extends ReserveRole {
    private final Map<Long, Snapshot> pendingSnapshots = new HashMap<Long, Snapshot>();
    private int nextSnapshotOffset;

    public PassiveRole(RaftServerContext context) {
        super(context);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.PASSIVE;
    }

    @Override
    public CompletableFuture<RaftRole> open() {
        return ((CompletableFuture)super.open().thenRun(this::truncateUncommittedEntries)).thenApply(v -> this);
    }

    private void truncateUncommittedEntries() {
        if (this.role() == RaftServer.Role.PASSIVE) {
            RaftLogWriter writer = this.context.getLogWriter();
            writer.truncate(this.context.getCommitIndex());
        }
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        return this.handleAppend(request);
    }

    protected CompletableFuture<AppendResponse> handleAppend(AppendRequest request) {
        CompletableFuture<AppendResponse> future = new CompletableFuture<AppendResponse>();
        RaftLogWriter writer = this.context.getLogWriter();
        if (!this.checkTerm(request, writer, future)) {
            return future;
        }
        if (!this.checkPreviousEntry(request, writer, future)) {
            return future;
        }
        this.appendEntries(request, writer, future);
        return future;
    }

    protected boolean checkTerm(AppendRequest request, RaftLogWriter writer, CompletableFuture<AppendResponse> future) {
        if (request.term() < this.context.getTerm()) {
            this.log.debug("Rejected {}: request term is less than the current term ({})", (Object)request, (Object)this.context.getTerm());
            return this.failAppend(writer.getLastIndex(), future);
        }
        return true;
    }

    protected boolean checkPreviousEntry(AppendRequest request, RaftLogWriter writer, CompletableFuture<AppendResponse> future) {
        Indexed lastEntry = writer.getLastEntry();
        if (lastEntry != null) {
            if (request.prevLogIndex() > lastEntry.index()) {
                this.log.debug("Rejected {}: Previous index ({}) is greater than the local log's last index ({})", new Object[]{request, request.prevLogIndex(), lastEntry.index()});
                return this.failAppend(lastEntry.index(), future);
            }
            if (request.prevLogIndex() < lastEntry.index()) {
                this.log.debug("Rejected {}: Previous index ({}) is less than the local log's last index ({})", new Object[]{request, request.prevLogIndex(), lastEntry.index()});
                return this.failAppend(lastEntry.index(), future);
            }
            if (request.prevLogTerm() != ((RaftLogEntry)lastEntry.entry()).term()) {
                this.log.debug("Rejected {}: Previous entry term ({}) does not equal the local log's last term ({})", new Object[]{request, request.prevLogTerm(), ((RaftLogEntry)lastEntry.entry()).term()});
                return this.failAppend(lastEntry.index() - 1L, future);
            }
        } else if (request.prevLogIndex() > 0L) {
            this.log.debug("Rejected {}: Previous index ({}) is greater than the local log's last index (0)", (Object)request, (Object)request.prevLogIndex());
            return this.failAppend(0L, future);
        }
        return true;
    }

    protected void appendEntries(AppendRequest request, RaftLogWriter writer, CompletableFuture<AppendResponse> future) {
        long lastEntryIndex = request.prevLogIndex() + (long)request.entries().size();
        long commitIndex = Math.max(this.context.getCommitIndex(), Math.min(request.commitIndex(), lastEntryIndex));
        long lastLogIndex = request.prevLogIndex();
        for (RaftLogEntry entry : request.entries()) {
            writer.append(entry);
            this.log.trace("Appended {}", (Object)entry);
            if (++lastLogIndex != commitIndex) continue;
            break;
        }
        long previousCommitIndex = this.context.getCommitIndex();
        this.context.setCommitIndex(commitIndex);
        if (this.context.getCommitIndex() > previousCommitIndex) {
            this.log.trace("Committed entries up to index {}", (Object)commitIndex);
        }
        this.context.getStateMachine().applyAll(this.context.getCommitIndex());
        this.succeedAppend(lastLogIndex, future);
    }

    protected boolean failAppend(long lastLogIndex, CompletableFuture<AppendResponse> future) {
        return this.completeAppend(false, lastLogIndex, future);
    }

    protected boolean succeedAppend(long lastLogIndex, CompletableFuture<AppendResponse> future) {
        return this.completeAppend(true, lastLogIndex, future);
    }

    protected boolean completeAppend(boolean succeeded, long lastLogIndex, CompletableFuture<AppendResponse> future) {
        future.complete(this.logResponse(((AppendResponse.Builder)AppendResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(succeeded).withLastLogIndex(lastLogIndex).build()));
        return succeeded;
    }

    @Override
    public CompletableFuture<QueryResponse> onQuery(QueryRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.context.getStateMachine().getLastApplied() < request.session()) {
            this.log.trace("State out of sync, forwarding query to leader");
            return this.queryForward(request);
        }
        RaftSessionContext session = this.context.getStateMachine().getSessions().getSession(request.session());
        if (session == null) {
            this.log.trace("State out of sync, forwarding query to leader");
            return this.queryForward(request);
        }
        if (session.readConsistency() == ReadConsistency.SEQUENTIAL) {
            if (this.context.getLogWriter().getLastIndex() < this.context.getCommitIndex()) {
                this.log.trace("State out of sync, forwarding query to leader");
                return this.queryForward(request);
            }
            Indexed entry = new Indexed(request.index(), (Object)new QueryEntry(this.context.getTerm(), System.currentTimeMillis(), request.session(), request.sequenceNumber(), request.operation()), 0);
            return this.applyQuery((Indexed<QueryEntry>)entry).thenApply(this::logResponse);
        }
        return this.queryForward(request);
    }

    private CompletableFuture<QueryResponse> queryForward(QueryRequest request) {
        if (this.context.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        this.log.trace("Forwarding {}", (Object)request);
        return ((CompletableFuture)this.forward(request, this.context.getProtocol()::query).exceptionally(error -> ((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    protected CompletableFuture<QueryResponse> queryLocal(Indexed<QueryEntry> entry) {
        return this.applyQuery(entry);
    }

    protected CompletableFuture<QueryResponse> applyQuery(Indexed<QueryEntry> entry) {
        CompletableFuture<QueryResponse> future = new CompletableFuture<QueryResponse>();
        this.context.getStateMachine().apply(entry).whenComplete((result, error) -> this.completeOperation((OperationResult)result, QueryResponse.newBuilder(), (Throwable)error, future));
        return future;
    }

    protected <T extends OperationResponse> void completeOperation(OperationResult result, OperationResponse.Builder<?, T> builder, Throwable error, CompletableFuture<T> future) {
        if (this.isOpen()) {
            if (result != null) {
                builder.withIndex(result.index());
                builder.withEventIndex(result.eventIndex());
                if (result.failed()) {
                    error = result.error();
                }
            }
            if (error == null) {
                future.complete(((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.OK)).withResult(result != null ? result.result() : null).build());
            } else if (error instanceof CompletionException && error.getCause() instanceof RaftException) {
                future.complete(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)error.getCause()).getType(), error.getMessage())).build());
            } else if (error instanceof RaftException) {
                future.complete(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)error).getType(), error.getMessage())).build());
            } else {
                this.log.warn("An unexpected error occurred: {}", error);
                future.complete(((OperationResponse.Builder)((OperationResponse.Builder)builder.withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR, error.getMessage())).build());
            }
        }
    }

    @Override
    public CompletableFuture<InstallResponse> onInstall(InstallRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        if (request.term() < this.context.getTerm()) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request term is less than the local term " + request.term())).build()));
        }
        Snapshot pendingSnapshot = this.pendingSnapshots.get(request.snapshotId());
        if (pendingSnapshot != null && request.snapshotIndex() != pendingSnapshot.index()) {
            pendingSnapshot.close();
            pendingSnapshot.delete();
            pendingSnapshot = null;
            this.nextSnapshotOffset = 0;
        }
        if (pendingSnapshot == null) {
            if (request.chunkOffset() > 0) {
                return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request chunk offset is invalid")).build()));
            }
            pendingSnapshot = this.context.getSnapshotStore().newSnapshot(ServiceId.from(request.snapshotId()), request.snapshotIndex(), WallClockTimestamp.from((long)request.snapshotTimestamp()));
            this.nextSnapshotOffset = 0;
        }
        if (request.chunkOffset() > this.nextSnapshotOffset) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request chunk offset does not match the next chunk offset")).build()));
        }
        try (SnapshotWriter writer = pendingSnapshot.openWriter();){
            writer.write(request.data());
        }
        if (request.complete()) {
            pendingSnapshot.persist().complete();
            this.pendingSnapshots.remove(request.snapshotId());
            this.nextSnapshotOffset = 0;
        } else {
            ++this.nextSnapshotOffset;
            this.pendingSnapshots.put(request.snapshotId(), pendingSnapshot);
        }
        return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)InstallResponse.newBuilder().withStatus(RaftResponse.Status.OK)).build()));
    }

    @Override
    public CompletableFuture<Void> close() {
        for (Snapshot pendingSnapshot : this.pendingSnapshots.values()) {
            pendingSnapshot.close();
            pendingSnapshot.delete();
        }
        return super.close();
    }
}

