/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.cluster.impl.RaftMemberContext;
import io.atomix.protocols.raft.impl.OperationResult;
import io.atomix.protocols.raft.impl.RaftServerContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.roles.ActiveRole;
import io.atomix.protocols.raft.roles.LeaderAppender;
import io.atomix.protocols.raft.roles.PendingCommand;
import io.atomix.protocols.raft.roles.RaftRole;
import io.atomix.protocols.raft.session.impl.RaftSessionContext;
import io.atomix.protocols.raft.storage.log.RaftLogWriter;
import io.atomix.protocols.raft.storage.log.entry.CloseSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.CommandEntry;
import io.atomix.protocols.raft.storage.log.entry.ConfigurationEntry;
import io.atomix.protocols.raft.storage.log.entry.InitializeEntry;
import io.atomix.protocols.raft.storage.log.entry.KeepAliveEntry;
import io.atomix.protocols.raft.storage.log.entry.MetadataEntry;
import io.atomix.protocols.raft.storage.log.entry.OpenSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.QueryEntry;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.protocols.raft.storage.system.Configuration;
import io.atomix.storage.journal.Indexed;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.Scheduled;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public final class LeaderRole
extends ActiveRole {
    private final LeaderAppender appender = new LeaderAppender(this);
    private Scheduled appendTimer;
    private long configuring;

    public LeaderRole(RaftServerContext context) {
        super(context);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.LEADER;
    }

    @Override
    public synchronized CompletableFuture<RaftRole> open() {
        this.takeLeadership();
        this.appendInitialEntries();
        this.commitInitialEntries();
        return ((CompletableFuture)super.open().thenRun(this::startAppendTimer)).thenApply(v -> this);
    }

    private void takeLeadership() {
        this.context.setLeader(this.context.getCluster().getMember().memberId());
        this.context.getClusterState().getRemoteMemberStates().forEach(m -> m.resetState(this.context.getLog()));
    }

    private void appendInitialEntries() {
        long term = this.context.getTerm();
        RaftLogWriter writer = this.context.getLogWriter();
        Indexed indexed = writer.append(new InitializeEntry(term, this.appender.getTime()));
        this.log.trace("Appended {}", (Object)indexed.index());
        this.configure(this.context.getCluster().getMembers());
    }

    private CompletableFuture<Void> commitInitialEntries() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.appender.appendEntries(this.appender.getIndex()).whenComplete((resultIndex, error) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (error == null) {
                    this.context.getStateMachine().apply((long)resultIndex);
                    future.complete(null);
                } else {
                    this.context.setLeader(null);
                    this.context.transition(RaftServer.Role.FOLLOWER);
                }
            }
        });
        return future;
    }

    private void startAppendTimer() {
        this.log.trace("Starting append timer");
        this.appendTimer = this.context.getThreadContext().schedule(Duration.ZERO, this.context.getHeartbeatInterval(), this::appendMembers);
    }

    private void appendMembers() {
        this.context.checkThread();
        if (this.isOpen()) {
            this.appender.appendEntries();
        }
    }

    boolean configuring() {
        return this.configuring > 0L;
    }

    boolean initializing() {
        return this.appender.getIndex() == 0L || this.context.getCommitIndex() < this.appender.getIndex();
    }

    protected CompletableFuture<Long> configure(Collection<RaftMember> members) {
        this.context.checkThread();
        long term = this.context.getTerm();
        RaftLogWriter writer = this.context.getLogWriter();
        Indexed entry = writer.append(new ConfigurationEntry(term, System.currentTimeMillis(), members));
        this.log.trace("Appended {}", (Object)entry);
        this.configuring = entry.index();
        this.context.getClusterState().configure(new Configuration(entry.index(), ((ConfigurationEntry)entry.entry()).term(), ((ConfigurationEntry)entry.entry()).timestamp(), ((ConfigurationEntry)entry.entry()).members()));
        return this.appender.appendEntries(entry.index()).whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                this.configuring = 0L;
            }
        });
    }

    @Override
    public CompletableFuture<JoinResponse> onJoin(JoinRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.configuring() || this.initializing()) {
            return CompletableFuture.completedFuture(this.logResponse(((JoinResponse.Builder)JoinResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).build()));
        }
        if (this.context.getCluster().getMember(request.member().memberId()) != null) {
            return CompletableFuture.completedFuture(this.logResponse(((JoinResponse.Builder)((JoinResponse.Builder)((JoinResponse.Builder)((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withIndex(this.context.getClusterState().getConfiguration().index())).withTerm(this.context.getClusterState().getConfiguration().term())).withTime(this.context.getClusterState().getConfiguration().time())).withMembers(this.context.getCluster().getMembers())).build()));
        }
        RaftMember member = request.member();
        Collection<RaftMember> members = this.context.getCluster().getMembers();
        members.add(new DefaultRaftMember(member.memberId(), member.getType(), member.getStatus(), Instant.now()));
        CompletableFuture<JoinResponse> future = new CompletableFuture<JoinResponse>();
        this.configure(members).whenComplete((index, error) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (error == null) {
                    future.complete(this.logResponse(((JoinResponse.Builder)((JoinResponse.Builder)((JoinResponse.Builder)((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withIndex((long)index)).withTerm(this.context.getClusterState().getConfiguration().term())).withTime(this.context.getClusterState().getConfiguration().time())).withMembers(members)).build()));
                } else {
                    future.complete(this.logResponse(((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<ReconfigureResponse> onReconfigure(ReconfigureRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.configuring() || this.initializing()) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)ReconfigureResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).build()));
        }
        DefaultRaftMember existingMember = this.context.getClusterState().getMember(request.member().memberId());
        if (existingMember == null) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNKNOWN_SESSION)).build()));
        }
        if (request.index() > 0L && request.index() < this.context.getClusterState().getConfiguration().index() || request.term() != this.context.getClusterState().getConfiguration().term() && (existingMember.getType() != request.member().getType() || existingMember.getStatus() != request.member().getStatus())) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.CONFIGURATION_ERROR)).build()));
        }
        existingMember.update(request.member().getType(), Instant.now());
        Collection<RaftMember> members = this.context.getCluster().getMembers();
        CompletableFuture<ReconfigureResponse> future = new CompletableFuture<ReconfigureResponse>();
        this.configure(members).whenComplete((index, error) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (error == null) {
                    future.complete(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withIndex((long)index)).withTerm(this.context.getClusterState().getConfiguration().term())).withTime(this.context.getClusterState().getConfiguration().time())).withMembers(members)).build()));
                } else {
                    future.complete(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<LeaveResponse> onLeave(LeaveRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.configuring() || this.initializing()) {
            return CompletableFuture.completedFuture(this.logResponse(((LeaveResponse.Builder)LeaveResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).build()));
        }
        if (this.context.getCluster().getMember(request.member().memberId()) == null) {
            return CompletableFuture.completedFuture(this.logResponse(((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withMembers(this.context.getCluster().getMembers())).build()));
        }
        RaftMember member = request.member();
        Collection<RaftMember> members = this.context.getCluster().getMembers();
        members.remove(member);
        CompletableFuture<LeaveResponse> future = new CompletableFuture<LeaveResponse>();
        this.configure(members).whenComplete((index, error) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (error == null) {
                    future.complete(this.logResponse(((LeaveResponse.Builder)((LeaveResponse.Builder)((LeaveResponse.Builder)((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withIndex((long)index)).withTerm(this.context.getClusterState().getConfiguration().term())).withTime(this.context.getClusterState().getConfiguration().time())).withMembers(members)).build()));
                } else {
                    future.complete(this.logResponse(((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<PollResponse> onPoll(PollRequest request) {
        this.logRequest(request);
        RaftMemberContext member = this.context.getClusterState().getMemberState(request.candidate());
        if (member != null) {
            member.resetFailureCount();
            if (member.getMember().getStatus() == RaftMember.Status.UNAVAILABLE) {
                member.getMember().update(RaftMember.Status.AVAILABLE, Instant.now());
                this.configure(this.context.getCluster().getMembers());
            }
        }
        return CompletableFuture.completedFuture(this.logResponse(((PollResponse.Builder)PollResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withAccepted(false).build()));
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        if (this.updateTermAndLeader(request.term(), null)) {
            this.log.debug("Received greater term");
            this.context.transition(RaftServer.Role.FOLLOWER);
            return super.onVote(request);
        }
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build()));
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.context.checkThread();
        if (this.updateTermAndLeader(request.term(), request.leader())) {
            CompletableFuture<AppendResponse> future = super.onAppend(request);
            this.context.transition(RaftServer.Role.FOLLOWER);
            return future;
        }
        if (request.term() < this.context.getTerm()) {
            this.logRequest(request);
            return CompletableFuture.completedFuture(this.logResponse(((AppendResponse.Builder)AppendResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(false).withLastLogIndex(this.context.getLogWriter().getLastIndex()).build()));
        }
        this.context.setLeader(request.leader()).transition(RaftServer.Role.FOLLOWER);
        return super.onAppend(request);
    }

    @Override
    public CompletableFuture<MetadataResponse> onMetadata(MetadataRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        CompletableFuture<MetadataResponse> future = new CompletableFuture<MetadataResponse>();
        Indexed entry = new Indexed(this.context.getStateMachine().getLastApplied(), (Object)new MetadataEntry(this.context.getTerm(), System.currentTimeMillis(), request.session()), 0);
        this.context.getStateMachine().apply((Indexed<? extends RaftLogEntry>)entry).whenComplete((result, error) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (error == null) {
                    future.complete(this.logResponse(((MetadataResponse.Builder)MetadataResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withSessions(result.sessions()).build()));
                } else {
                    future.complete(this.logResponse(((MetadataResponse.Builder)((MetadataResponse.Builder)MetadataResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<CommandResponse> onCommand(CommandRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        RaftSessionContext session = this.context.getStateMachine().getSessions().getSession(request.session());
        if (session == null) {
            return CompletableFuture.completedFuture(this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNKNOWN_SESSION)).build()));
        }
        long sequenceNumber = request.sequenceNumber();
        PendingCommand existingCommand = session.getCommand(sequenceNumber);
        if (existingCommand != null) {
            if (sequenceNumber == session.nextRequestSequence()) {
                session.removeCommand(sequenceNumber);
                this.commitCommand(existingCommand.request(), existingCommand.future());
                session.setRequestSequence(sequenceNumber);
                this.drainCommands(session);
            }
            return existingCommand.future();
        }
        CompletableFuture<CommandResponse> future = new CompletableFuture<CommandResponse>();
        if (sequenceNumber > session.nextRequestSequence()) {
            session.registerCommand(request.sequenceNumber(), new PendingCommand(request, future));
            return future;
        }
        if (sequenceNumber <= session.getCommandSequence()) {
            OperationResult result = session.getResult(sequenceNumber);
            if (result != null) {
                this.completeOperation(result, CommandResponse.newBuilder(), null, future);
            } else {
                future.complete(((CommandResponse.Builder)((CommandResponse.Builder)((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withIndex(session.getLastApplied())).withEventIndex(0L)).withResult(new byte[0])).build());
            }
        } else {
            this.commitCommand(request, future);
            session.setRequestSequence(sequenceNumber);
            this.drainCommands(session);
        }
        return future.thenApply(this::logResponse);
    }

    private void drainCommands(RaftSessionContext session) {
        long nextSequence = session.nextRequestSequence();
        PendingCommand nextCommand = session.removeCommand(nextSequence);
        while (nextCommand != null) {
            this.commitCommand(nextCommand.request(), nextCommand.future());
            session.setRequestSequence(nextSequence);
            nextSequence = session.nextRequestSequence();
            nextCommand = session.removeCommand(nextSequence);
        }
    }

    private void commitCommand(CommandRequest request, CompletableFuture<CommandResponse> future) {
        long term = this.context.getTerm();
        long timestamp = System.currentTimeMillis();
        RaftLogWriter writer = this.context.getLogWriter();
        Indexed entry = writer.append(new CommandEntry(term, timestamp, request.session(), request.sequenceNumber(), request.operation()));
        this.log.trace("Appended {}", (Object)entry);
        this.appender.appendEntries(entry.index()).whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (commitError == null) {
                    this.context.getStateMachine().apply(entry.index()).whenComplete((result, error) -> {
                        if (this.isOpen()) {
                            this.completeOperation((OperationResult)result, CommandResponse.newBuilder(), (Throwable)error, future);
                        }
                    });
                } else {
                    future.complete(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build());
                }
            }
        });
    }

    @Override
    public CompletableFuture<QueryResponse> onQuery(QueryRequest request) {
        CompletableFuture future;
        this.context.checkThread();
        this.logRequest(request);
        if (this.context.getStateMachine().getLastApplied() < request.session()) {
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNKNOWN_SESSION, "Session has not yet been created. You're seeing into the future!")).build()));
        }
        RaftSessionContext session = this.context.getStateMachine().getSessions().getSession(request.session());
        if (session == null) {
            this.log.warn("Unknown session {}", (Object)request.session());
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.UNKNOWN_SESSION)).build()));
        }
        Indexed entry = new Indexed(request.index(), (Object)new QueryEntry(this.context.getTerm(), System.currentTimeMillis(), request.session(), request.sequenceNumber(), request.operation()), 0);
        switch (session.readConsistency()) {
            case SEQUENTIAL: {
                future = this.queryLocal((Indexed<QueryEntry>)entry);
                break;
            }
            case LINEARIZABLE_LEASE: {
                future = this.queryBoundedLinearizable((Indexed<QueryEntry>)entry);
                break;
            }
            case LINEARIZABLE: {
                future = this.queryLinearizable((Indexed<QueryEntry>)entry);
                break;
            }
            default: {
                future = Futures.exceptionalFuture((Throwable)new IllegalStateException("Unknown consistency level: " + (Object)((Object)session.readConsistency())));
            }
        }
        return future.thenApply(this::logResponse);
    }

    private CompletableFuture<QueryResponse> queryBoundedLinearizable(Indexed<QueryEntry> entry) {
        return this.applyQuery(entry);
    }

    private CompletableFuture<QueryResponse> queryLinearizable(Indexed<QueryEntry> entry) {
        return this.applyQuery(entry).thenComposeAsync(response -> ((CompletableFuture)this.appender.appendEntries().thenApply(index -> response)).exceptionally(error -> ((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.QUERY_FAILURE, error.getMessage())).build()), (Executor)this.context.getThreadContext());
    }

    @Override
    public CompletableFuture<OpenSessionResponse> onOpenSession(OpenSessionRequest request) {
        long term = this.context.getTerm();
        long timestamp = System.currentTimeMillis();
        long timeout = request.timeout() != 0L ? request.timeout() : this.context.getSessionTimeout().toMillis();
        this.context.checkThread();
        this.logRequest(request);
        RaftLogWriter writer = this.context.getLogWriter();
        Indexed entry = writer.append(new OpenSessionEntry(term, timestamp, request.member(), request.serviceName(), request.serviceType(), request.readConsistency(), timeout));
        this.log.trace("Appended {}", (Object)entry);
        CompletableFuture<OpenSessionResponse> future = new CompletableFuture<OpenSessionResponse>();
        this.appender.appendEntries(entry.index()).whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (commitError == null) {
                    this.context.getStateMachine().apply(entry.index()).whenComplete((sessionId, sessionError) -> {
                        if (this.isOpen()) {
                            if (sessionError == null) {
                                future.complete(this.logResponse(((OpenSessionResponse.Builder)OpenSessionResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withSession((long)sessionId).withTimeout(timeout).build()));
                            } else if (sessionError instanceof CompletionException && sessionError.getCause() instanceof RaftException) {
                                future.complete(this.logResponse(((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)sessionError.getCause()).getType(), sessionError.getMessage())).build()));
                            } else if (sessionError instanceof RaftException) {
                                future.complete(this.logResponse(((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)sessionError).getType(), sessionError.getMessage())).build()));
                            } else {
                                future.complete(this.logResponse(((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR, sessionError.getMessage())).build()));
                            }
                        }
                    });
                } else {
                    future.complete(this.logResponse(((OpenSessionResponse.Builder)((OpenSessionResponse.Builder)OpenSessionResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<KeepAliveResponse> onKeepAlive(KeepAliveRequest request) {
        long term = this.context.getTerm();
        long timestamp = System.currentTimeMillis();
        this.context.checkThread();
        this.logRequest(request);
        RaftLogWriter writer = this.context.getLogWriter();
        Indexed entry = writer.append(new KeepAliveEntry(term, timestamp, request.sessionIds(), request.commandSequenceNumbers(), request.eventIndexes()));
        this.log.trace("Appended {}", (Object)entry);
        CompletableFuture<KeepAliveResponse> future = new CompletableFuture<KeepAliveResponse>();
        this.appender.appendEntries(entry.index()).whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (commitError == null) {
                    this.context.getStateMachine().apply(entry.index()).whenCompleteAsync((sessionResult, sessionError) -> {
                        if (this.isOpen()) {
                            if (sessionError == null) {
                                for (long sessionId : sessionResult) {
                                    RaftSessionContext session = this.context.getStateMachine().getSessions().getSession(sessionId);
                                    if (session == null || !session.getState().active()) continue;
                                    this.drainCommands(session);
                                }
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)KeepAliveResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withLeader(this.context.getCluster().getMember().memberId()).withMembers(this.context.getCluster().getMembers().stream().map(RaftMember::memberId).filter(m -> m != null).collect(Collectors.toList())).withSessionIds((long[])sessionResult).build()));
                            } else if (sessionError instanceof CompletionException && sessionError.getCause() instanceof RaftException) {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withLeader(this.context.getCluster().getMember().memberId()).withError(((RaftException)sessionError.getCause()).getType(), sessionError.getMessage())).build()));
                            } else if (sessionError instanceof RaftException) {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withLeader(this.context.getCluster().getMember().memberId()).withError(((RaftException)sessionError).getType(), sessionError.getMessage())).build()));
                            } else {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withLeader(this.context.getCluster().getMember().memberId()).withError(RaftError.Type.PROTOCOL_ERROR, sessionError.getMessage())).build()));
                            }
                        }
                    }, (Executor)this.context.getThreadContext());
                } else {
                    future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withLeader(this.context.getCluster().getMember().memberId()).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<CloseSessionResponse> onCloseSession(CloseSessionRequest request) {
        long term = this.context.getTerm();
        long timestamp = System.currentTimeMillis();
        this.context.checkThread();
        this.logRequest(request);
        RaftLogWriter writer = this.context.getLogWriter();
        Indexed entry = writer.append(new CloseSessionEntry(term, timestamp, request.session()));
        this.log.trace("Appended {}", (Object)entry);
        CompletableFuture<CloseSessionResponse> future = new CompletableFuture<CloseSessionResponse>();
        this.appender.appendEntries(entry.index()).whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (commitError == null) {
                    this.context.getStateMachine().apply(entry.index()).whenComplete((closeResult, closeError) -> {
                        if (this.isOpen()) {
                            if (closeError == null) {
                                future.complete(this.logResponse(((CloseSessionResponse.Builder)CloseSessionResponse.newBuilder().withStatus(RaftResponse.Status.OK)).build()));
                            } else if (closeError instanceof CompletionException && closeError.getCause() instanceof RaftException) {
                                future.complete(this.logResponse(((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)closeError.getCause()).getType(), closeError.getMessage())).build()));
                            } else if (closeError instanceof RaftException) {
                                future.complete(this.logResponse(((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(((RaftException)closeError).getType(), closeError.getMessage())).build()));
                            } else {
                                future.complete(this.logResponse(((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR, closeError.getMessage())).build()));
                            }
                        }
                    });
                } else {
                    future.complete(this.logResponse(((CloseSessionResponse.Builder)((CloseSessionResponse.Builder)CloseSessionResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    private void cancelAppendTimer() {
        if (this.appendTimer != null) {
            this.log.trace("Cancelling append timer");
            this.appendTimer.cancel();
        }
    }

    private void stepDown() {
        if (this.context.getLeader() != null && this.context.getLeader().equals(this.context.getCluster().getMember())) {
            this.context.setLeader(null);
        }
    }

    private void failPendingCommands() {
        for (RaftSessionContext session : this.context.getStateMachine().getSessions().getSessions()) {
            for (PendingCommand command : session.clearCommands()) {
                command.future().complete(this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.newBuilder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.COMMAND_FAILURE, "Request sequence number " + command.request().sequenceNumber() + " out of sequence")).withLastSequence(session.getRequestSequence())).build()));
            }
        }
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)super.close().thenRun(this.appender::close)).thenRun(this::cancelAppendTimer)).thenRun(this::stepDown)).thenRun(this::failPendingCommands);
    }
}

