/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.impl.RaftServerContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.CloseSessionRequest;
import io.atomix.protocols.raft.protocol.CloseSessionResponse;
import io.atomix.protocols.raft.protocol.CommandRequest;
import io.atomix.protocols.raft.protocol.CommandResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.JoinRequest;
import io.atomix.protocols.raft.protocol.JoinResponse;
import io.atomix.protocols.raft.protocol.KeepAliveRequest;
import io.atomix.protocols.raft.protocol.KeepAliveResponse;
import io.atomix.protocols.raft.protocol.LeaveRequest;
import io.atomix.protocols.raft.protocol.LeaveResponse;
import io.atomix.protocols.raft.protocol.MetadataRequest;
import io.atomix.protocols.raft.protocol.MetadataResponse;
import io.atomix.protocols.raft.protocol.OpenSessionRequest;
import io.atomix.protocols.raft.protocol.OpenSessionResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.QueryRequest;
import io.atomix.protocols.raft.protocol.QueryResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.ReconfigureRequest;
import io.atomix.protocols.raft.protocol.ReconfigureResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.roles.AbstractRole;
import io.atomix.protocols.raft.storage.system.Configuration;
import io.atomix.utils.concurrent.Futures;
import java.util.concurrent.CompletableFuture;

public class InactiveRole
extends AbstractRole {
    public InactiveRole(RaftServerContext context) {
        super(context);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.INACTIVE;
    }

    @Override
    public CompletableFuture<ConfigureResponse> onConfigure(ConfigureRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        Configuration configuration = new Configuration(request.index(), request.term(), request.timestamp(), request.members());
        this.context.getClusterState().configure(configuration);
        if (this.context.getCommitIndex() >= this.context.getClusterState().getConfiguration().index()) {
            this.context.getClusterState().commit();
        }
        return CompletableFuture.completedFuture(this.logResponse(((ConfigureResponse.Builder)ConfigureResponse.newBuilder().withStatus(RaftResponse.Status.OK)).build()));
    }

    @Override
    public CompletableFuture<MetadataResponse> onMetadata(MetadataRequest request) {
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("inactive state"));
    }

    @Override
    public CompletableFuture<KeepAliveResponse> onKeepAlive(KeepAliveRequest request) {
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("inactive state"));
    }

    @Override
    public CompletableFuture<OpenSessionResponse> onOpenSession(OpenSessionRequest request) {
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("inactive state"));
    }

    @Override
    public CompletableFuture<CloseSessionResponse> onCloseSession(CloseSessionRequest request) {
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("inactive state"));
    }

    @Override
    public CompletableFuture<InstallResponse> onInstall(InstallRequest request) {
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("inactive state"));
    }

    @Override
    public CompletableFuture<JoinResponse> onJoin(JoinRequest request) {
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("inactive state"));
    }

    @Override
    public CompletableFuture<ReconfigureResponse> onReconfigure(ReconfigureRequest request) {
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("inactive state"));
    }

    @Override
    public CompletableFuture<LeaveResponse> onLeave(LeaveRequest request) {
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("inactive state"));
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("inactive state"));
    }

    @Override
    public CompletableFuture<PollResponse> onPoll(PollRequest request) {
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("inactive state"));
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("inactive state"));
    }

    @Override
    public CompletableFuture<CommandResponse> onCommand(CommandRequest request) {
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("inactive state"));
    }

    @Override
    public CompletableFuture<QueryResponse> onQuery(QueryRequest request) {
        return Futures.exceptionalFuture((Throwable)new IllegalStateException("inactive state"));
    }
}

