/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.cluster.impl.RaftMemberContext;
import io.atomix.protocols.raft.impl.RaftServerContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.roles.ActiveRole;
import io.atomix.protocols.raft.roles.FollowerAppender;
import io.atomix.protocols.raft.roles.RaftRole;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.protocols.raft.utils.Quorum;
import io.atomix.storage.journal.Indexed;
import io.atomix.utils.concurrent.Scheduled;
import java.time.Duration;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public final class FollowerRole
extends ActiveRole {
    private final FollowerAppender appender;
    private final Random random = new Random();
    private Scheduled heartbeatTimer;

    public FollowerRole(RaftServerContext context) {
        super(context);
        this.appender = new FollowerAppender(context);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.FOLLOWER;
    }

    @Override
    public synchronized CompletableFuture<RaftRole> open() {
        return ((CompletableFuture)super.open().thenRun(this::startHeartbeatTimeout)).thenApply(v -> this);
    }

    private void startHeartbeatTimeout() {
        this.log.trace("Starting heartbeat timer");
        this.resetHeartbeatTimeout();
    }

    private void resetHeartbeatTimeout() {
        this.context.checkThread();
        if (this.isClosed()) {
            return;
        }
        if (this.heartbeatTimer != null) {
            this.heartbeatTimer.cancel();
        }
        Duration delay = this.context.getElectionTimeout().plus(Duration.ofMillis(this.random.nextInt((int)this.context.getElectionTimeout().toMillis())));
        this.heartbeatTimer = this.context.getThreadContext().schedule(delay, () -> {
            this.heartbeatTimer = null;
            if (this.isOpen()) {
                this.context.setLeader(null);
                this.log.debug("Heartbeat timed out in {}", (Object)delay);
                this.sendPollRequests();
            }
        });
    }

    private void sendPollRequests() {
        this.heartbeatTimer = this.context.getThreadContext().schedule(this.context.getElectionTimeout(), () -> {
            this.log.debug("Failed to poll a majority of the cluster in {}", (Object)this.context.getElectionTimeout());
            this.resetHeartbeatTimeout();
        });
        AtomicBoolean complete = new AtomicBoolean();
        HashSet votingMembers = new HashSet(this.context.getClusterState().getActiveMemberStates().stream().map(RaftMemberContext::getMember).collect(Collectors.toList()));
        if (votingMembers.isEmpty()) {
            this.context.transition(RaftServer.Role.CANDIDATE);
            return;
        }
        Quorum quorum = new Quorum(this.context.getClusterState().getQuorum(), elected -> {
            complete.set(true);
            if (elected.booleanValue()) {
                this.context.transition(RaftServer.Role.CANDIDATE);
            } else {
                this.resetHeartbeatTimeout();
            }
        });
        Indexed lastEntry = this.context.getLogWriter().getLastEntry();
        long lastTerm = lastEntry != null ? ((RaftLogEntry)lastEntry.entry()).term() : 0L;
        this.log.debug("Polling members {}", votingMembers);
        for (DefaultRaftMember member : votingMembers) {
            this.log.debug("Polling {} for next term {}", (Object)member, (Object)(this.context.getTerm() + 1L));
            PollRequest request = PollRequest.newBuilder().withTerm(this.context.getTerm()).withCandidate(this.context.getCluster().getMember().memberId()).withLastLogIndex(lastEntry != null ? lastEntry.index() : 0L).withLastLogTerm(lastTerm).build();
            this.context.getProtocol().poll(member.memberId(), request).whenCompleteAsync((response, error) -> {
                this.context.checkThread();
                if (this.isOpen() && !complete.get()) {
                    if (error != null) {
                        this.log.warn("{}", (Object)error.getMessage());
                        quorum.fail();
                    } else {
                        if (response.term() > this.context.getTerm()) {
                            this.context.setTerm(response.term());
                        }
                        if (!response.accepted()) {
                            this.log.debug("Received rejected poll from {}", (Object)member);
                            quorum.fail();
                        } else if (response.term() != this.context.getTerm()) {
                            this.log.debug("Received accepted poll for a different term from {}", (Object)member);
                            quorum.fail();
                        } else {
                            this.log.debug("Received accepted poll from {}", (Object)member);
                            quorum.succeed();
                        }
                    }
                }
            }, (Executor)this.context.getThreadContext());
        }
    }

    @Override
    public CompletableFuture<InstallResponse> onInstall(InstallRequest request) {
        CompletableFuture<InstallResponse> future = super.onInstall(request);
        this.resetHeartbeatTimeout();
        return future;
    }

    @Override
    public CompletableFuture<ConfigureResponse> onConfigure(ConfigureRequest request) {
        CompletableFuture<ConfigureResponse> future = super.onConfigure(request);
        this.resetHeartbeatTimeout();
        return future;
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        CompletableFuture<AppendResponse> future = super.onAppend(request);
        this.resetHeartbeatTimeout();
        this.appender.appendEntries();
        return future;
    }

    @Override
    protected VoteResponse handleVote(VoteRequest request) {
        VoteResponse response = super.handleVote(request);
        if (response.voted()) {
            this.resetHeartbeatTimeout();
        }
        return response;
    }

    private void cancelHeartbeatTimeout() {
        if (this.heartbeatTimer != null) {
            this.log.trace("Cancelling heartbeat timer");
            this.heartbeatTimer.cancel();
        }
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return ((CompletableFuture)super.close().thenRun(this.appender::close)).thenRun(this::cancelHeartbeatTimeout);
    }
}

