/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.cluster.impl.RaftMemberContext;
import io.atomix.protocols.raft.impl.RaftServerContext;
import io.atomix.protocols.raft.roles.AbstractAppender;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;

final class FollowerAppender
extends AbstractAppender {
    public FollowerAppender(RaftServerContext context) {
        super(context);
    }

    public void appendEntries() {
        if (this.open) {
            for (RaftMemberContext member : this.server.getClusterState().getAssignedPassiveMemberStates()) {
                this.appendEntries(member);
            }
        }
    }

    @Override
    protected boolean hasMoreEntries(RaftMemberContext member) {
        return member.getMember().getType() == RaftMember.Type.PASSIVE && member.getLogReader().hasNext();
    }

    @Override
    protected void appendEntries(RaftMemberContext member) {
        if (!this.open) {
            return;
        }
        Snapshot snapshot = this.server.getSnapshotStore().getSnapshotByIndex(member.getLogReader().getCurrentIndex());
        if (snapshot != null && member.getSnapshotIndex() < snapshot.index()) {
            if (member.canInstall()) {
                this.sendInstallRequest(member, this.buildInstallRequest(member));
            }
        } else if (member.canAppend() && this.hasMoreEntries(member)) {
            this.sendAppendRequest(member, this.buildAppendRequest(member, Math.min(this.server.getCommitIndex(), this.server.getLogWriter().getLastIndex())));
        }
    }
}

