/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.cluster.impl.RaftMemberContext;
import io.atomix.protocols.raft.impl.RaftServerContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.roles.ActiveRole;
import io.atomix.protocols.raft.roles.RaftRole;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.protocols.raft.utils.Quorum;
import io.atomix.storage.journal.Indexed;
import io.atomix.utils.concurrent.Scheduled;
import java.time.Duration;
import java.util.HashSet;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public final class CandidateRole
extends ActiveRole {
    private final Random random = new Random();
    private Quorum quorum;
    private Scheduled currentTimer;

    public CandidateRole(RaftServerContext context) {
        super(context);
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.CANDIDATE;
    }

    @Override
    public synchronized CompletableFuture<RaftRole> open() {
        return ((CompletableFuture)super.open().thenRun(this::startElection)).thenApply(v -> this);
    }

    void startElection() {
        this.log.info("Starting election");
        this.sendVoteRequests();
    }

    private void sendVoteRequests() {
        this.context.checkThread();
        if (this.isClosed()) {
            return;
        }
        if (this.currentTimer != null) {
            this.currentTimer.cancel();
        }
        this.context.setTerm(this.context.getTerm() + 1L).setLastVotedFor(this.context.getCluster().getMember().memberId());
        Duration delay = this.context.getElectionTimeout().plus(Duration.ofMillis(this.random.nextInt((int)this.context.getElectionTimeout().toMillis())));
        this.currentTimer = this.context.getThreadContext().schedule(delay, () -> {
            this.log.debug("Election timed out");
            if (this.quorum != null) {
                this.quorum.cancel();
                this.quorum = null;
            }
            this.sendVoteRequests();
            this.log.debug("Restarted election");
        });
        AtomicBoolean complete = new AtomicBoolean();
        HashSet votingMembers = new HashSet(this.context.getClusterState().getActiveMemberStates().stream().map(RaftMemberContext::getMember).collect(Collectors.toList()));
        if (votingMembers.isEmpty()) {
            this.log.debug("Single member cluster. Transitioning directly to leader.", (Object)this.context.getCluster().getMember().memberId());
            this.context.transition(RaftServer.Role.LEADER);
            return;
        }
        Quorum quorum = new Quorum(this.context.getClusterState().getQuorum(), elected -> {
            complete.set(true);
            if (elected.booleanValue()) {
                this.context.transition(RaftServer.Role.LEADER);
            } else {
                this.context.transition(RaftServer.Role.FOLLOWER);
            }
        });
        Indexed lastEntry = this.context.getLogWriter().getLastEntry();
        long lastTerm = lastEntry != null ? ((RaftLogEntry)lastEntry.entry()).term() : 0L;
        this.log.debug("Requesting votes for term {}", (Object)this.context.getTerm());
        for (DefaultRaftMember member : votingMembers) {
            this.log.debug("Requesting vote from {} for term {}", (Object)member, (Object)this.context.getTerm());
            VoteRequest request = VoteRequest.newBuilder().withTerm(this.context.getTerm()).withCandidate(this.context.getCluster().getMember().memberId()).withLastLogIndex(lastEntry != null ? lastEntry.index() : 0L).withLastLogTerm(lastTerm).build();
            this.context.getProtocol().vote(member.memberId(), request).whenCompleteAsync((response, error) -> {
                this.context.checkThread();
                if (this.isOpen() && !complete.get()) {
                    if (error != null) {
                        this.log.warn(error.getMessage());
                        quorum.fail();
                    } else if (response.term() > this.context.getTerm()) {
                        this.log.debug("Received greater term from {}", (Object)member);
                        this.context.setTerm(response.term());
                        complete.set(true);
                        this.context.transition(RaftServer.Role.FOLLOWER);
                    } else if (!response.voted()) {
                        this.log.debug("Received rejected vote from {}", (Object)member);
                        quorum.fail();
                    } else if (response.term() != this.context.getTerm()) {
                        this.log.debug("Received successful vote for a different term from {}", (Object)member);
                        quorum.fail();
                    } else {
                        this.log.debug("Received successful vote from {}", (Object)member);
                        quorum.succeed();
                    }
                }
            }, (Executor)this.context.getThreadContext());
        }
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.context.checkThread();
        if (request.term() >= this.context.getTerm()) {
            this.context.setTerm(request.term());
            this.context.transition(RaftServer.Role.FOLLOWER);
        }
        return super.onAppend(request);
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.updateTermAndLeader(request.term(), null)) {
            CompletableFuture<VoteResponse> future = super.onVote(request);
            this.context.transition(RaftServer.Role.FOLLOWER);
            return future;
        }
        if (request.candidate() == this.context.getCluster().getMember().memberId()) {
            return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withVoted(true).build()));
        }
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build()));
    }

    private void cancelElection() {
        this.context.checkThread();
        if (this.currentTimer != null) {
            this.log.debug("Cancelling election");
            this.currentTimer.cancel();
        }
        if (this.quorum != null) {
            this.quorum.cancel();
            this.quorum = null;
        }
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return super.close().thenRun(this::cancelElection);
    }
}

