/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.impl.RaftServerContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.PollRequest;
import io.atomix.protocols.raft.protocol.PollResponse;
import io.atomix.protocols.raft.protocol.RaftRequest;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.protocol.VoteRequest;
import io.atomix.protocols.raft.protocol.VoteResponse;
import io.atomix.protocols.raft.roles.PassiveRole;
import io.atomix.protocols.raft.storage.log.RaftLogWriter;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.storage.journal.Indexed;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public abstract class ActiveRole
extends PassiveRole {
    protected ActiveRole(RaftServerContext context) {
        super(context);
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        boolean transition = this.updateTermAndLeader(request.term(), request.leader());
        CompletableFuture<AppendResponse> future = this.handleAppend(request);
        if (transition) {
            this.context.transition(RaftServer.Role.FOLLOWER);
        }
        return future;
    }

    @Override
    protected void appendEntries(AppendRequest request, RaftLogWriter writer, CompletableFuture<AppendResponse> future) {
        long lastEntryIndex = request.prevLogIndex() + (long)request.entries().size();
        long commitIndex = Math.max(this.context.getCommitIndex(), Math.min(request.commitIndex(), lastEntryIndex));
        for (RaftLogEntry entry : request.entries()) {
            writer.append(entry);
            this.log.trace("Appended {}", (Object)entry);
        }
        long previousCommitIndex = this.context.getCommitIndex();
        this.context.setCommitIndex(commitIndex);
        if (this.context.getCommitIndex() > previousCommitIndex) {
            this.log.trace("Committed entries up to index {}", (Object)commitIndex);
        }
        this.context.getStateMachine().applyAll(this.context.getCommitIndex());
        this.succeedAppend(lastEntryIndex, future);
    }

    @Override
    public CompletableFuture<PollResponse> onPoll(PollRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), null);
        return CompletableFuture.completedFuture(this.logResponse(this.handlePoll(request)));
    }

    protected PollResponse handlePoll(PollRequest request) {
        if (request.term() < this.context.getTerm()) {
            this.log.debug("Rejected {}: candidate's term is less than the current term", (Object)request);
            return ((PollResponse.Builder)PollResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withAccepted(false).build();
        }
        if (this.isLogUpToDate(request.lastLogIndex(), request.lastLogTerm(), request)) {
            return ((PollResponse.Builder)PollResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withAccepted(true).build();
        }
        return ((PollResponse.Builder)PollResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withAccepted(false).build();
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        boolean transition = this.updateTermAndLeader(request.term(), null);
        CompletableFuture<VoteResponse> future = CompletableFuture.completedFuture(this.logResponse(this.handleVote(request)));
        if (transition) {
            this.context.transition(RaftServer.Role.FOLLOWER);
        }
        return future;
    }

    protected VoteResponse handleVote(VoteRequest request) {
        if (request.term() < this.context.getTerm()) {
            this.log.debug("Rejected {}: candidate's term is less than the current term", (Object)request);
            return ((VoteResponse.Builder)VoteResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        if (this.context.getLeader() != null) {
            this.log.debug("Rejected {}: leader already exists", (Object)request);
            return ((VoteResponse.Builder)VoteResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        if (!this.context.getClusterState().getRemoteMemberStates().stream().map(m -> m.getMember().memberId()).collect(Collectors.toSet()).contains(request.candidate())) {
            this.log.debug("Rejected {}: candidate is not known to the local member", (Object)request);
            return ((VoteResponse.Builder)VoteResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        if (this.context.getLastVotedFor() == null) {
            if (this.isLogUpToDate(request.lastLogIndex(), request.lastLogTerm(), request)) {
                this.context.setLastVotedFor(request.candidate());
                return ((VoteResponse.Builder)VoteResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withVoted(true).build();
            }
            return ((VoteResponse.Builder)VoteResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        if (this.context.getLastVotedFor() == request.candidate()) {
            this.log.debug("Accepted {}: already voted for {}", (Object)request, (Object)this.context.getCluster().getMember(this.context.getLastVotedFor()).memberId());
            return ((VoteResponse.Builder)VoteResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withVoted(true).build();
        }
        this.log.debug("Rejected {}: already voted for {}", (Object)request, (Object)this.context.getCluster().getMember(this.context.getLastVotedFor()).memberId());
        return ((VoteResponse.Builder)VoteResponse.newBuilder().withStatus(RaftResponse.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
    }

    boolean isLogUpToDate(long lastIndex, long lastTerm, RaftRequest request) {
        Indexed lastEntry = this.context.getLogWriter().getLastEntry();
        if (lastEntry == null) {
            this.log.debug("Accepted {}: candidate's log is up-to-date", (Object)request);
            return true;
        }
        if (lastTerm < ((RaftLogEntry)lastEntry.entry()).term()) {
            this.log.debug("Rejected {}: candidate's last log entry ({}) is at a lower term than the local log ({})", new Object[]{request, lastTerm, ((RaftLogEntry)lastEntry.entry()).term()});
            return false;
        }
        if (lastTerm == ((RaftLogEntry)lastEntry.entry()).term() && lastIndex < lastEntry.index()) {
            this.log.debug("Rejected {}: candidate's last log entry ({}) is at a lower index than the local log ({})", new Object[]{request, lastIndex, lastEntry.index()});
            return false;
        }
        this.log.debug("Accepted {}: candidate's log is up-to-date", (Object)request);
        return true;
    }
}

