/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import com.google.common.base.MoreObjects;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.impl.RaftServerContext;
import io.atomix.protocols.raft.protocol.RaftRequest;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.roles.RaftRole;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import org.slf4j.Logger;

public abstract class AbstractRole
implements RaftRole {
    protected final Logger log;
    protected final RaftServerContext context;
    private boolean open = true;

    protected AbstractRole(RaftServerContext context) {
        this.context = context;
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftServer.class).addValue((Object)context.getName()).add("role", (Object)this.role()).build());
    }

    @Override
    public abstract RaftServer.Role role();

    protected final <R extends RaftRequest> R logRequest(R request) {
        this.log.trace("Received {}", request);
        return request;
    }

    protected final <R extends RaftResponse> R logResponse(R response) {
        this.log.trace("Sending {}", response);
        return response;
    }

    public CompletableFuture<RaftRole> open() {
        this.context.checkThread();
        this.open = true;
        return CompletableFuture.completedFuture(null);
    }

    public boolean isOpen() {
        return this.open;
    }

    protected <T extends RaftRequest, U extends RaftResponse> CompletableFuture<U> forward(T request, BiFunction<MemberId, T, CompletableFuture<U>> function) {
        CompletableFuture future = new CompletableFuture();
        DefaultRaftMember leader = this.context.getLeader();
        if (leader == null) {
            return Futures.exceptionalFuture((Throwable)new RaftException.NoLeader("No leader found", new Object[0]));
        }
        function.apply(leader.memberId(), (MemberId)((Object)request)).whenCompleteAsync((response, error) -> {
            if (error == null) {
                future.complete(response);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }, (Executor)this.context.getThreadContext());
        return future;
    }

    protected boolean updateTermAndLeader(long term, MemberId leader) {
        if (term > this.context.getTerm() || term == this.context.getTerm() && this.context.getLeader() == null && leader != null) {
            this.context.setTerm(term);
            this.context.setLeader(leader);
            this.context.getClusterState().reset();
            return true;
        }
        return false;
    }

    public CompletableFuture<Void> close() {
        this.context.checkThread();
        this.open = false;
        return CompletableFuture.completedFuture(null);
    }

    public boolean isClosed() {
        return !this.open;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("context", (Object)this.context).toString();
    }
}

