/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.roles;

import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.cluster.impl.RaftMemberContext;
import io.atomix.protocols.raft.impl.RaftServerContext;
import io.atomix.protocols.raft.protocol.AppendRequest;
import io.atomix.protocols.raft.protocol.AppendResponse;
import io.atomix.protocols.raft.protocol.ConfigureRequest;
import io.atomix.protocols.raft.protocol.ConfigureResponse;
import io.atomix.protocols.raft.protocol.InstallRequest;
import io.atomix.protocols.raft.protocol.InstallResponse;
import io.atomix.protocols.raft.protocol.RaftRequest;
import io.atomix.protocols.raft.protocol.RaftResponse;
import io.atomix.protocols.raft.storage.log.RaftLogReader;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.protocols.raft.storage.snapshot.SnapshotReader;
import io.atomix.storage.journal.Indexed;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.slf4j.Logger;

abstract class AbstractAppender
implements AutoCloseable {
    private static final int MAX_BATCH_SIZE = 32768;
    protected final Logger log;
    protected final RaftServerContext server;
    protected boolean open = true;

    AbstractAppender(RaftServerContext server) {
        this.server = (RaftServerContext)Preconditions.checkNotNull((Object)server, (Object)"context cannot be null");
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftServer.class).addValue((Object)server.getName()).build());
    }

    protected abstract void appendEntries(RaftMemberContext var1);

    protected AppendRequest buildAppendRequest(RaftMemberContext member, long lastIndex) {
        RaftLogReader reader = member.getLogReader();
        if (!reader.hasNext()) {
            return this.buildAppendEmptyRequest(member);
        }
        if (member.getFailureCount() > 0) {
            return this.buildAppendEmptyRequest(member);
        }
        return this.buildAppendEntriesRequest(member, lastIndex);
    }

    protected AppendRequest buildAppendEmptyRequest(RaftMemberContext member) {
        RaftLogReader reader = member.getLogReader();
        Indexed prevEntry = reader != null ? reader.getCurrentEntry() : null;
        DefaultRaftMember leader = this.server.getLeader();
        return AppendRequest.newBuilder().withTerm(this.server.getTerm()).withLeader(leader != null ? leader.memberId() : null).withPrevLogIndex(prevEntry != null ? prevEntry.index() : 0L).withPrevLogTerm(prevEntry != null ? ((RaftLogEntry)prevEntry.entry()).term() : 0L).withEntries(Collections.emptyList()).withCommitIndex(this.server.getCommitIndex()).build();
    }

    protected AppendRequest buildAppendEntriesRequest(RaftMemberContext member, long lastIndex) {
        RaftLogReader reader = member.getLogReader();
        Indexed prevEntry = reader.getCurrentEntry();
        DefaultRaftMember leader = this.server.getLeader();
        AppendRequest.Builder builder = AppendRequest.newBuilder().withTerm(this.server.getTerm()).withLeader(leader != null ? leader.memberId() : null).withPrevLogIndex(prevEntry != null ? prevEntry.index() : 0L).withPrevLogTerm(prevEntry != null ? ((RaftLogEntry)prevEntry.entry()).term() : 0L).withCommitIndex(this.server.getCommitIndex());
        ArrayList<RaftLogEntry> entries = new ArrayList<RaftLogEntry>();
        int size = 0;
        while (reader.hasNext()) {
            Snapshot snapshot;
            Indexed entry = reader.next();
            entries.add((RaftLogEntry)entry.entry());
            if (entry.index() != lastIndex && (size += entry.size()) < 32768 && (snapshot = this.server.getSnapshotStore().getSnapshotByIndex(entry.index())) == null) continue;
            break;
        }
        return builder.withEntries(entries).build();
    }

    protected void sendAppendRequest(RaftMemberContext member, AppendRequest request) {
        if (request.entries().isEmpty() && !member.canHeartbeat()) {
            return;
        }
        member.startAppend();
        long timestamp = System.currentTimeMillis();
        this.log.trace("Sending {} to {}", (Object)request, (Object)member.getMember().memberId());
        this.server.getProtocol().append(member.getMember().memberId(), request).whenCompleteAsync((response, error) -> {
            if (!request.entries().isEmpty()) {
                member.completeAppend(System.currentTimeMillis() - timestamp);
            } else {
                member.completeAppend();
            }
            if (this.open) {
                if (error == null) {
                    this.log.trace("Received {} from {}", response, (Object)member.getMember().memberId());
                    this.handleAppendResponse(member, request, (AppendResponse)response);
                } else {
                    this.handleAppendResponseFailure(member, request, (Throwable)error);
                }
            }
        }, (Executor)this.server.getThreadContext());
        if (!request.entries().isEmpty() && this.hasMoreEntries(member)) {
            this.appendEntries(member);
        }
    }

    protected void handleAppendRequestFailure(RaftMemberContext member, AppendRequest request, Throwable error) {
        this.failAttempt(member, request, error);
    }

    protected void handleAppendResponseFailure(RaftMemberContext member, AppendRequest request, Throwable error) {
        this.failAttempt(member, request, error);
    }

    protected void handleAppendResponse(RaftMemberContext member, AppendRequest request, AppendResponse response) {
        if (response.status() == RaftResponse.Status.OK) {
            this.handleAppendResponseOk(member, request, response);
        } else {
            this.handleAppendResponseError(member, request, response);
        }
    }

    protected void handleAppendResponseOk(RaftMemberContext member, AppendRequest request, AppendResponse response) {
        this.succeedAttempt(member);
        if (response.succeeded()) {
            this.updateMatchIndex(member, response);
            if (request.prevLogIndex() != response.lastLogIndex() && this.hasMoreEntries(member)) {
                this.appendEntries(member);
            }
        } else if (response.term() > this.server.getTerm()) {
            this.server.setTerm(response.term()).setLeader(null);
            this.server.transition(RaftServer.Role.FOLLOWER);
        } else {
            this.resetMatchIndex(member, response);
            this.resetNextIndex(member);
            if (response.lastLogIndex() != request.prevLogIndex() && this.hasMoreEntries(member)) {
                this.appendEntries(member);
            }
        }
    }

    protected void handleAppendResponseError(RaftMemberContext member, AppendRequest request, AppendResponse response) {
        int failures = member.incrementFailureCount();
        if (failures <= 3 || failures % 100 == 0) {
            this.log.warn("{} to {} failed: {}", new Object[]{request, member.getMember().memberId(), response.error() != null ? response.error() : ""});
        }
    }

    protected void succeedAttempt(RaftMemberContext member) {
        member.resetFailureCount();
    }

    protected void failAttempt(RaftMemberContext member, RaftRequest request, Throwable error) {
        int failures = member.incrementFailureCount();
        if (failures <= 3 || failures % 100 == 0) {
            this.log.warn("{} to {} failed: {}", new Object[]{request, member.getMember().memberId(), error.getMessage()});
        }
    }

    protected abstract boolean hasMoreEntries(RaftMemberContext var1);

    protected void updateMatchIndex(RaftMemberContext member, AppendResponse response) {
        member.setMatchIndex(response.lastLogIndex());
    }

    protected void resetMatchIndex(RaftMemberContext member, AppendResponse response) {
        member.setMatchIndex(response.lastLogIndex());
        this.log.trace("Reset match index for {} to {}", (Object)member, (Object)member.getMatchIndex());
    }

    protected void resetNextIndex(RaftMemberContext member) {
        RaftLogReader reader = member.getLogReader();
        if (member.getMatchIndex() != 0L) {
            reader.reset(member.getMatchIndex() + 1L);
        } else {
            reader.reset();
        }
        this.log.trace("Reset next index for {} to {} + 1", (Object)member, (Object)member.getMatchIndex());
    }

    protected ConfigureRequest buildConfigureRequest(RaftMemberContext member) {
        DefaultRaftMember leader = this.server.getLeader();
        return ConfigureRequest.newBuilder().withTerm(this.server.getTerm()).withLeader(leader != null ? leader.memberId() : null).withIndex(this.server.getClusterState().getConfiguration().index()).withTime(this.server.getClusterState().getConfiguration().time()).withMembers(this.server.getClusterState().getConfiguration().members()).build();
    }

    protected void sendConfigureRequest(RaftMemberContext member, ConfigureRequest request) {
        this.log.debug("Configuring {}", (Object)member.getMember().memberId());
        member.startConfigure();
        this.log.trace("Sending {} to {}", (Object)request, (Object)member.getMember().memberId());
        this.server.getProtocol().configure(member.getMember().memberId(), request).whenCompleteAsync((response, error) -> {
            member.completeConfigure();
            if (this.open) {
                if (error == null) {
                    this.log.trace("Received {} from {}", response, (Object)member.getMember().memberId());
                    this.handleConfigureResponse(member, request, (ConfigureResponse)response);
                } else {
                    this.log.warn("Failed to configure {}", (Object)member.getMember().memberId());
                    this.handleConfigureResponseFailure(member, request, (Throwable)error);
                }
            }
        }, (Executor)this.server.getThreadContext());
    }

    protected void handleConfigureRequestFailure(RaftMemberContext member, ConfigureRequest request, Throwable error) {
        this.failAttempt(member, request, error);
    }

    protected void handleConfigureResponseFailure(RaftMemberContext member, ConfigureRequest request, Throwable error) {
        this.failAttempt(member, request, error);
    }

    protected void handleConfigureResponse(RaftMemberContext member, ConfigureRequest request, ConfigureResponse response) {
        if (response.status() == RaftResponse.Status.OK) {
            this.handleConfigureResponseOk(member, request, response);
        } else {
            this.handleConfigureResponseError(member, request, response);
        }
    }

    protected void handleConfigureResponseOk(RaftMemberContext member, ConfigureRequest request, ConfigureResponse response) {
        this.succeedAttempt(member);
        member.setConfigTerm(request.term());
        member.setConfigIndex(request.index());
        this.appendEntries(member);
    }

    protected void handleConfigureResponseError(RaftMemberContext member, ConfigureRequest request, ConfigureResponse response) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InstallRequest buildInstallRequest(RaftMemberContext member) {
        InstallRequest request;
        Snapshot snapshot = this.server.getSnapshotStore().getSnapshotByIndex(member.getLogReader().getCurrentIndex());
        if (member.getNextSnapshotIndex() != snapshot.index()) {
            member.setNextSnapshotIndex(snapshot.index());
            member.setNextSnapshotOffset(0);
        }
        Snapshot snapshot2 = snapshot;
        synchronized (snapshot2) {
            try (SnapshotReader reader = snapshot.openReader();){
                reader.skip(member.getNextSnapshotOffset() * 32768);
                byte[] data = new byte[Math.min(32768, reader.remaining())];
                reader.read(data);
                DefaultRaftMember leader = this.server.getLeader();
                request = InstallRequest.newBuilder().withTerm(this.server.getTerm()).withLeader(leader != null ? leader.memberId() : null).withId((Long)snapshot.serviceId().id()).withIndex(snapshot.index()).withOffset(member.getNextSnapshotOffset()).withData(data).withComplete(!reader.hasRemaining()).build();
            }
        }
        return request;
    }

    protected void sendInstallRequest(RaftMemberContext member, InstallRequest request) {
        member.startInstall();
        this.log.trace("Sending {} to {}", (Object)request, (Object)member.getMember().memberId());
        this.server.getProtocol().install(member.getMember().memberId(), request).whenCompleteAsync((response, error) -> {
            member.completeInstall();
            if (this.open) {
                if (error == null) {
                    this.log.trace("Received {} from {}", response, (Object)member.getMember().memberId());
                    this.handleInstallResponse(member, request, (InstallResponse)response);
                } else {
                    this.log.warn("Failed to install {}", (Object)member.getMember().memberId());
                    this.handleInstallResponseFailure(member, request, (Throwable)error);
                }
            }
        }, (Executor)this.server.getThreadContext());
    }

    protected void handleInstallRequestFailure(RaftMemberContext member, InstallRequest request, Throwable error) {
        this.failAttempt(member, request, error);
    }

    protected void handleInstallResponseFailure(RaftMemberContext member, InstallRequest request, Throwable error) {
        member.setNextSnapshotIndex(0L);
        member.setNextSnapshotOffset(0);
        this.failAttempt(member, request, error);
    }

    protected void handleInstallResponse(RaftMemberContext member, InstallRequest request, InstallResponse response) {
        if (response.status() == RaftResponse.Status.OK) {
            this.handleInstallResponseOk(member, request, response);
        } else {
            this.handleInstallResponseError(member, request, response);
        }
    }

    protected void handleInstallResponseOk(RaftMemberContext member, InstallRequest request, InstallResponse response) {
        this.succeedAttempt(member);
        if (request.complete()) {
            member.setNextSnapshotIndex(0L);
            member.setNextSnapshotOffset(0);
            member.setSnapshotIndex(request.snapshotIndex());
        } else {
            member.setNextSnapshotOffset(request.chunkOffset() + 1);
        }
        this.appendEntries(member);
    }

    protected void handleInstallResponseError(RaftMemberContext member, InstallRequest request, InstallResponse response) {
        this.log.warn("Failed to install {}", (Object)member.getMember().memberId());
        member.setNextSnapshotIndex(0L);
        member.setNextSnapshotOffset(0);
    }

    @Override
    public void close() {
        this.open = false;
    }
}

