/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftError;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.protocol.AbstractRaftResponse;
import io.atomix.protocols.raft.protocol.RaftResponse;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class KeepAliveResponse
extends AbstractRaftResponse {
    private final MemberId leader;
    private final Collection<MemberId> members;
    private final long[] sessionIds;

    public static Builder newBuilder() {
        return new Builder();
    }

    public KeepAliveResponse(RaftResponse.Status status, RaftError error, MemberId leader, Collection<MemberId> members, long[] sessionIds) {
        super(status, error);
        this.leader = leader;
        this.members = members;
        this.sessionIds = sessionIds;
    }

    public MemberId leader() {
        return this.leader;
    }

    public Collection<MemberId> members() {
        return this.members;
    }

    public long[] sessionIds() {
        return this.sessionIds;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.leader, this.members});
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof KeepAliveResponse) {
            KeepAliveResponse response = (KeepAliveResponse)object;
            return response.status == this.status && (response.leader == null && this.leader == null || response.leader != null && this.leader != null && response.leader.equals(this.leader)) && (response.members == null && this.members == null || response.members != null && this.members != null && response.members.equals(this.members));
        }
        return false;
    }

    @Override
    public String toString() {
        if (this.status == RaftResponse.Status.OK) {
            return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("leader", (Object)this.leader).add("members", this.members).add("sessionIds", (Object)Arrays.toString(this.sessionIds)).toString();
        }
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("error", (Object)this.error).toString();
    }

    public static class Builder
    extends AbstractRaftResponse.Builder<Builder, KeepAliveResponse> {
        private MemberId leader;
        private Collection<MemberId> members;
        private long[] sessionIds;

        public Builder withLeader(MemberId leader) {
            this.leader = leader;
            return this;
        }

        public Builder withMembers(Collection<MemberId> members) {
            this.members = (Collection)Preconditions.checkNotNull(members, (Object)"members cannot be null");
            return this;
        }

        public Builder withSessionIds(long[] sessionIds) {
            this.sessionIds = (long[])Preconditions.checkNotNull((Object)sessionIds, (Object)"sessionIds cannot be null");
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.status == RaftResponse.Status.OK) {
                Preconditions.checkNotNull(this.members, (Object)"members cannot be null");
                Preconditions.checkNotNull((Object)this.sessionIds, (Object)"sessionIds cannot be null");
            }
        }

        public KeepAliveResponse build() {
            this.validate();
            return new KeepAliveResponse(this.status, this.error, this.leader, this.members, this.sessionIds);
        }
    }
}

