/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.protocol.AbstractRaftRequest;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AppendRequest
extends AbstractRaftRequest {
    private final long term;
    private final String leader;
    private final long prevLogIndex;
    private final long prevLogTerm;
    private final List<RaftLogEntry> entries;
    private final long commitIndex;

    public static Builder newBuilder() {
        return new Builder();
    }

    public AppendRequest(long term, String leader, long prevLogIndex, long prevLogTerm, List<RaftLogEntry> entries, long commitIndex) {
        this.term = term;
        this.leader = leader;
        this.prevLogIndex = prevLogIndex;
        this.prevLogTerm = prevLogTerm;
        this.entries = entries;
        this.commitIndex = commitIndex;
    }

    public long term() {
        return this.term;
    }

    public MemberId leader() {
        return MemberId.from(this.leader);
    }

    public long prevLogIndex() {
        return this.prevLogIndex;
    }

    public long prevLogTerm() {
        return this.prevLogTerm;
    }

    public List<RaftLogEntry> entries() {
        return this.entries;
    }

    public long commitIndex() {
        return this.commitIndex;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.term, this.leader, this.prevLogIndex, this.prevLogTerm, this.entries, this.commitIndex);
    }

    public boolean equals(Object object) {
        if (object instanceof AppendRequest) {
            AppendRequest request = (AppendRequest)object;
            return request.term == this.term && request.leader == this.leader && request.prevLogIndex == this.prevLogIndex && request.prevLogTerm == this.prevLogTerm && request.entries.equals(this.entries) && request.commitIndex == this.commitIndex;
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("leader", (Object)this.leader).add("prevLogIndex", this.prevLogIndex).add("prevLogTerm", this.prevLogTerm).add("entries", this.entries.size()).add("commitIndex", this.commitIndex).toString();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, AppendRequest> {
        private long term;
        private String leader;
        private long logIndex;
        private long logTerm;
        private List<RaftLogEntry> entries;
        private long commitIndex = -1L;

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public Builder withLeader(MemberId leader) {
            this.leader = (String)((Object)((MemberId)Preconditions.checkNotNull((Object)leader, (Object)"leader cannot be null")).id());
            return this;
        }

        public Builder withPrevLogIndex(long prevLogIndex) {
            Preconditions.checkArgument((prevLogIndex >= 0L ? 1 : 0) != 0, (Object)"prevLogIndex must be positive");
            this.logIndex = prevLogIndex;
            return this;
        }

        public Builder withPrevLogTerm(long prevLogTerm) {
            Preconditions.checkArgument((prevLogTerm >= 0L ? 1 : 0) != 0, (Object)"prevLogTerm must be positive");
            this.logTerm = prevLogTerm;
            return this;
        }

        public Builder withEntries(RaftLogEntry ... entries) {
            return this.withEntries(Arrays.asList((Object[])Preconditions.checkNotNull((Object)entries, (Object)"entries cannot be null")));
        }

        public Builder withEntries(List<RaftLogEntry> entries) {
            this.entries = (List)Preconditions.checkNotNull(entries, (Object)"entries cannot be null");
            return this;
        }

        public Builder addEntry(RaftLogEntry entry) {
            this.entries.add((RaftLogEntry)Preconditions.checkNotNull((Object)entry, (Object)"entry"));
            return this;
        }

        public Builder withCommitIndex(long commitIndex) {
            Preconditions.checkArgument((commitIndex >= 0L ? 1 : 0) != 0, (Object)"commitIndex must be positive");
            this.commitIndex = commitIndex;
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            Preconditions.checkNotNull((Object)this.leader, (Object)"leader cannot be null");
            Preconditions.checkArgument((this.logIndex >= 0L ? 1 : 0) != 0, (Object)"prevLogIndex must be positive");
            Preconditions.checkArgument((this.logTerm >= 0L ? 1 : 0) != 0, (Object)"prevLogTerm must be positive");
            Preconditions.checkNotNull(this.entries, (Object)"entries cannot be null");
            Preconditions.checkArgument((this.commitIndex >= 0L ? 1 : 0) != 0, (Object)"commitIndex must be positive");
        }

        public AppendRequest build() {
            this.validate();
            return new AppendRequest(this.term, this.leader, this.logIndex, this.logTerm, this.entries, this.commitIndex);
        }
    }
}

