/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import io.atomix.protocols.raft.RaftException;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.impl.MetadataResult;
import io.atomix.protocols.raft.impl.OperationResult;
import io.atomix.protocols.raft.impl.RaftServerContext;
import io.atomix.protocols.raft.service.RaftService;
import io.atomix.protocols.raft.service.ServiceId;
import io.atomix.protocols.raft.service.ServiceType;
import io.atomix.protocols.raft.service.impl.DefaultServiceContext;
import io.atomix.protocols.raft.session.RaftSessionMetadata;
import io.atomix.protocols.raft.session.SessionId;
import io.atomix.protocols.raft.session.impl.RaftSessionContext;
import io.atomix.protocols.raft.session.impl.RaftSessionManager;
import io.atomix.protocols.raft.storage.log.RaftLog;
import io.atomix.protocols.raft.storage.log.RaftLogReader;
import io.atomix.protocols.raft.storage.log.entry.CloseSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.CommandEntry;
import io.atomix.protocols.raft.storage.log.entry.ConfigurationEntry;
import io.atomix.protocols.raft.storage.log.entry.InitializeEntry;
import io.atomix.protocols.raft.storage.log.entry.KeepAliveEntry;
import io.atomix.protocols.raft.storage.log.entry.MetadataEntry;
import io.atomix.protocols.raft.storage.log.entry.OpenSessionEntry;
import io.atomix.protocols.raft.storage.log.entry.QueryEntry;
import io.atomix.protocols.raft.storage.log.entry.RaftLogEntry;
import io.atomix.protocols.raft.storage.snapshot.Snapshot;
import io.atomix.storage.journal.Indexed;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.ThreadPoolContext;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class RaftServiceManager
implements AutoCloseable {
    private static final long COMPACT_INTERVAL_MILLIS = 10000L;
    private final Logger logger;
    private final RaftServerContext server;
    private final ScheduledExecutorService threadPool;
    private final RaftLog log;
    private final RaftLogReader reader;
    private final RaftSessionManager sessionManager = new RaftSessionManager();
    private final Map<String, DefaultServiceContext> services = new HashMap<String, DefaultServiceContext>();
    private volatile long lastApplied;

    public RaftServiceManager(RaftServerContext server, ScheduledExecutorService threadPool, ThreadContext threadContext) {
        this.server = (RaftServerContext)Preconditions.checkNotNull((Object)server, (Object)"state cannot be null");
        this.log = server.getLog();
        this.reader = this.log.openReader(1L, RaftLogReader.Mode.COMMITS);
        this.threadPool = threadPool;
        this.logger = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftServer.class).addValue((Object)server.getName()).build());
        threadContext.schedule(Duration.ofMillis(10000L), this::compactLog);
    }

    public RaftSessionManager getSessions() {
        return this.sessionManager;
    }

    public long getLastApplied() {
        return this.lastApplied;
    }

    private void setLastApplied(long lastApplied) {
        if (lastApplied > this.lastApplied) {
            Preconditions.checkArgument((lastApplied == this.lastApplied + 1L ? 1 : 0) != 0, (Object)"lastApplied must be sequential");
            this.lastApplied = lastApplied;
        } else {
            Preconditions.checkArgument((lastApplied == this.lastApplied ? 1 : 0) != 0, (Object)"lastApplied cannot be decreased");
        }
    }

    public void applyAll(long index) {
        if (index > this.lastApplied) {
            this.server.getThreadContext().execute(() -> this.apply(index));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> CompletableFuture<T> apply(long index) {
        while (this.reader.hasNext()) {
            Indexed entry;
            long nextIndex = this.reader.getNextIndex();
            if (nextIndex < index) {
                entry = this.reader.next();
                this.apply((Indexed<? extends RaftLogEntry>)entry);
                this.setLastApplied(entry.index());
                continue;
            }
            if (nextIndex == index) {
                try {
                    entry = this.reader.next();
                    if (entry.index() != index) {
                        throw new IllegalStateException("inconsistent index applying entry " + index + ": " + entry);
                    }
                    CompletableFuture<T> completableFuture = this.apply((Indexed<? extends RaftLogEntry>)entry);
                    return completableFuture;
                }
                finally {
                    this.setLastApplied(index);
                }
            }
            this.setLastApplied(index);
            return CompletableFuture.completedFuture(null);
        }
        return CompletableFuture.completedFuture(null);
    }

    public <T> CompletableFuture<T> apply(Indexed<? extends RaftLogEntry> entry) {
        this.logger.trace("Applying {}", entry);
        if (entry.type() == QueryEntry.class) {
            return this.applyQuery((Indexed<QueryEntry>)entry.cast());
        }
        if (entry.type() == CommandEntry.class) {
            return this.applyCommand((Indexed<CommandEntry>)entry.cast());
        }
        if (entry.type() == OpenSessionEntry.class) {
            return this.applyOpenSession((Indexed<OpenSessionEntry>)entry.cast());
        }
        if (entry.type() == KeepAliveEntry.class) {
            return this.applyKeepAlive((Indexed<KeepAliveEntry>)entry.cast());
        }
        if (entry.type() == CloseSessionEntry.class) {
            return this.applyCloseSession((Indexed<CloseSessionEntry>)entry.cast());
        }
        if (entry.type() == MetadataEntry.class) {
            return this.applyMetadata((Indexed<MetadataEntry>)entry.cast());
        }
        if (entry.type() == InitializeEntry.class) {
            return this.applyInitialize((Indexed<InitializeEntry>)entry.cast());
        }
        if (entry.type() == ConfigurationEntry.class) {
            return this.applyConfiguration((Indexed<ConfigurationEntry>)entry.cast());
        }
        return Futures.exceptionalFuture((Throwable)new RaftException.ProtocolException("Unknown entry type", new Object[0]));
    }

    private CompletableFuture<Void> applyInitialize(Indexed<InitializeEntry> entry) {
        for (DefaultServiceContext service : this.services.values()) {
            service.keepAliveSessions(entry.index(), ((InitializeEntry)entry.entry()).timestamp());
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> applyConfiguration(Indexed<ConfigurationEntry> entry) {
        for (DefaultServiceContext service : this.services.values()) {
            service.keepAliveSessions(entry.index(), ((ConfigurationEntry)entry.entry()).timestamp());
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<long[]> applyKeepAlive(Indexed<KeepAliveEntry> entry) {
        long[] sessionIds = ((KeepAliveEntry)entry.entry()).sessionIds();
        long[] commandSequences = ((KeepAliveEntry)entry.entry()).commandSequenceNumbers();
        long[] eventIndexes = ((KeepAliveEntry)entry.entry()).eventIndexes();
        ArrayList successfulSessionIds = new ArrayList(sessionIds.length);
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>(sessionIds.length);
        for (int i = 0; i < sessionIds.length; ++i) {
            long sessionId = sessionIds[i];
            long commandSequence = commandSequences[i];
            long eventIndex = eventIndexes[i];
            RaftSessionContext session = this.sessionManager.getSession(sessionId);
            if (session == null) continue;
            CompletionStage future = session.getStateMachineContext().keepAlive(entry.index(), ((KeepAliveEntry)entry.entry()).timestamp(), session, commandSequence, eventIndex).thenApply(succeeded -> {
                if (succeeded.booleanValue()) {
                    List list = successfulSessionIds;
                    synchronized (list) {
                        successfulSessionIds.add(sessionId);
                    }
                }
                return null;
            });
            futures.add(future);
        }
        for (DefaultServiceContext service : this.services.values()) {
            service.completeKeepAlive(entry.index(), ((KeepAliveEntry)entry.entry()).timestamp());
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> {
            List list = successfulSessionIds;
            synchronized (list) {
                return Longs.toArray((Collection)successfulSessionIds);
            }
        });
    }

    private CompletableFuture<Long> applyOpenSession(Indexed<OpenSessionEntry> entry) {
        DefaultServiceContext stateMachineExecutor = this.services.get(((OpenSessionEntry)entry.entry()).serviceName());
        if (stateMachineExecutor == null) {
            Supplier<RaftService> stateMachineSupplier = this.server.getStateMachineRegistry().getFactory(((OpenSessionEntry)entry.entry()).serviceType());
            if (stateMachineSupplier == null) {
                return Futures.exceptionalFuture((Throwable)new RaftException.UnknownService("Unknown service type " + ((OpenSessionEntry)entry.entry()).serviceType(), new Object[0]));
            }
            ServiceId serviceId = ServiceId.from(entry.index());
            stateMachineExecutor = new DefaultServiceContext(serviceId, ((OpenSessionEntry)entry.entry()).serviceName(), ServiceType.from(((OpenSessionEntry)entry.entry()).serviceType()), stateMachineSupplier.get(), this.server, this.sessionManager, (ThreadContext)new ThreadPoolContext(this.threadPool), (ThreadContext)new ThreadPoolContext(this.threadPool));
            this.services.put(((OpenSessionEntry)entry.entry()).serviceName(), stateMachineExecutor);
        }
        SessionId sessionId = SessionId.from(entry.index());
        RaftSessionContext session = new RaftSessionContext(sessionId, MemberId.from(((OpenSessionEntry)entry.entry()).memberId()), ((OpenSessionEntry)entry.entry()).serviceName(), ServiceType.from(((OpenSessionEntry)entry.entry()).serviceType()), ((OpenSessionEntry)entry.entry()).readConsistency(), ((OpenSessionEntry)entry.entry()).timeout(), stateMachineExecutor, this.server);
        this.sessionManager.registerSession(session);
        return stateMachineExecutor.openSession(entry.index(), ((OpenSessionEntry)entry.entry()).timestamp(), session);
    }

    private CompletableFuture<Void> applyCloseSession(Indexed<CloseSessionEntry> entry) {
        RaftSessionContext session = this.sessionManager.getSession(((CloseSessionEntry)entry.entry()).session());
        if (session == null) {
            return Futures.exceptionalFuture((Throwable)new RaftException.UnknownSession("Unknown session: " + ((CloseSessionEntry)entry.entry()).session(), new Object[0]));
        }
        DefaultServiceContext stateMachineExecutor = session.getStateMachineContext();
        return stateMachineExecutor.closeSession(entry.index(), ((CloseSessionEntry)entry.entry()).timestamp(), session);
    }

    private CompletableFuture<MetadataResult> applyMetadata(Indexed<MetadataEntry> entry) {
        if (((MetadataEntry)entry.entry()).session() > 0L) {
            RaftSessionContext session = this.sessionManager.getSession(((MetadataEntry)entry.entry()).session());
            if (session == null) {
                return Futures.exceptionalFuture((Throwable)new RaftException.UnknownSession("Unknown session: " + ((MetadataEntry)entry.entry()).session(), new Object[0]));
            }
            HashSet<RaftSessionMetadata> sessions = new HashSet<RaftSessionMetadata>();
            for (RaftSessionContext s : this.sessionManager.getSessions()) {
                if (!s.serviceName().equals(session.serviceName())) continue;
                sessions.add(new RaftSessionMetadata((Long)s.sessionId().id(), s.serviceName(), (String)((Object)s.serviceType().id())));
            }
            return CompletableFuture.completedFuture(new MetadataResult(sessions));
        }
        HashSet<RaftSessionMetadata> sessions = new HashSet<RaftSessionMetadata>();
        for (RaftSessionContext session : this.sessionManager.getSessions()) {
            sessions.add(new RaftSessionMetadata((Long)session.sessionId().id(), session.serviceName(), (String)((Object)session.serviceType().id())));
        }
        return CompletableFuture.completedFuture(new MetadataResult(sessions));
    }

    private CompletableFuture<OperationResult> applyCommand(Indexed<CommandEntry> entry) {
        RaftSessionContext session = this.sessionManager.getSession(((CommandEntry)entry.entry()).session());
        if (session == null) {
            return Futures.exceptionalFuture((Throwable)new RaftException.UnknownSession("unknown session: " + ((CommandEntry)entry.entry()).session(), new Object[0]));
        }
        return session.getStateMachineContext().executeCommand(entry.index(), ((CommandEntry)entry.entry()).sequenceNumber(), ((CommandEntry)entry.entry()).timestamp(), session, ((CommandEntry)entry.entry()).operation());
    }

    private CompletableFuture<OperationResult> applyQuery(Indexed<QueryEntry> entry) {
        RaftSessionContext session = this.sessionManager.getSession(((QueryEntry)entry.entry()).session());
        if (session == null) {
            return Futures.exceptionalFuture((Throwable)new RaftException.UnknownSession("unknown session " + ((QueryEntry)entry.entry()).session(), new Object[0]));
        }
        return session.getStateMachineContext().executeQuery(entry.index(), ((QueryEntry)entry.entry()).sequenceNumber(), ((QueryEntry)entry.entry()).timestamp(), session, ((QueryEntry)entry.entry()).operation());
    }

    private void compactLog() {
        long snapshotIndex = this.server.getLogWriter().getLastIndex();
        for (DefaultServiceContext stateMachineExecutor : this.services.values()) {
            Snapshot snapshot = this.server.getSnapshotStore().getSnapshotById(stateMachineExecutor.serviceId());
            if (snapshot == null) {
                return;
            }
            snapshotIndex = Math.min(snapshotIndex, snapshot.index());
        }
        this.server.getLog().compact(snapshotIndex);
    }

    @Override
    public void close() {
    }
}

