/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.RaftServer;
import io.atomix.protocols.raft.cluster.MemberId;
import io.atomix.protocols.raft.cluster.RaftCluster;
import io.atomix.protocols.raft.cluster.RaftMember;
import io.atomix.protocols.raft.impl.RaftServerContext;
import io.atomix.protocols.raft.storage.RaftStorage;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class DefaultRaftServer
implements RaftServer {
    private final Logger log;
    protected final RaftServerContext context;
    private volatile CompletableFuture<RaftServer> openFuture;
    private volatile CompletableFuture<Void> closeFuture;
    private Consumer<RaftMember> electionListener;
    private volatile boolean started;

    public DefaultRaftServer(RaftServerContext context) {
        this.context = (RaftServerContext)Preconditions.checkNotNull((Object)context, (Object)"context cannot be null");
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftServer.class).addValue((Object)context.getName()).build());
    }

    @Override
    public String name() {
        return this.context.getName();
    }

    @Override
    public RaftCluster cluster() {
        return this.context.getCluster();
    }

    @Override
    public RaftServer.Role getRole() {
        return this.context.getRole();
    }

    @Override
    public void addRoleChangeListener(Consumer<RaftServer.Role> listener) {
        this.context.addStateChangeListener(listener);
    }

    @Override
    public void removeRoleChangeListener(Consumer<RaftServer.Role> listener) {
        this.context.removeStateChangeListener(listener);
    }

    @Override
    public CompletableFuture<RaftServer> bootstrap() {
        return this.bootstrap(Collections.EMPTY_LIST);
    }

    @Override
    public CompletableFuture<RaftServer> bootstrap(MemberId ... cluster) {
        return this.bootstrap(Arrays.asList(cluster));
    }

    @Override
    public CompletableFuture<RaftServer> bootstrap(Collection<MemberId> cluster) {
        return this.start(() -> this.cluster().bootstrap(cluster));
    }

    @Override
    public CompletableFuture<RaftServer> join(MemberId ... cluster) {
        return this.join(Arrays.asList(cluster));
    }

    @Override
    public CompletableFuture<RaftServer> join(Collection<MemberId> cluster) {
        return this.start(() -> this.cluster().join(cluster));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<RaftServer> start(Supplier<CompletableFuture<Void>> joiner) {
        if (this.started) {
            return CompletableFuture.completedFuture(this);
        }
        if (this.openFuture == null) {
            DefaultRaftServer defaultRaftServer = this;
            synchronized (defaultRaftServer) {
                if (this.openFuture == null) {
                    CompletableFuture future = new CompletableFuture();
                    this.openFuture = future;
                    joiner.get().whenComplete((result, error) -> {
                        if (error == null) {
                            if (this.cluster().getLeader() != null) {
                                this.started = true;
                                future.complete(this);
                            } else {
                                this.electionListener = leader -> {
                                    if (this.electionListener != null) {
                                        this.started = true;
                                        future.complete(this);
                                        this.cluster().removeLeaderElectionListener(this.electionListener);
                                        this.electionListener = null;
                                    }
                                };
                                this.cluster().addLeaderElectionListener(this.electionListener);
                            }
                        } else {
                            future.completeExceptionally((Throwable)error);
                        }
                    });
                    return future.whenComplete((r, e) -> {
                        this.openFuture = null;
                    });
                }
            }
        }
        return this.openFuture.whenComplete((result, error) -> {
            if (error == null) {
                this.log.info("Server started successfully!");
            } else {
                this.log.warn("Failed to start server!");
            }
        });
    }

    @Override
    public boolean isRunning() {
        return this.started;
    }

    @Override
    public CompletableFuture<Void> shutdown() {
        if (!this.started) {
            return Futures.exceptionalFuture((Throwable)new IllegalStateException("context not open"));
        }
        CompletableFuture future = new CompletableFuture();
        this.context.getThreadContext().execute(() -> {
            this.started = false;
            this.context.transition(RaftServer.Role.INACTIVE);
            future.complete(null);
        });
        return future.whenCompleteAsync((result, error) -> {
            this.context.close();
            this.started = false;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> leave() {
        if (!this.started) {
            return CompletableFuture.completedFuture(null);
        }
        if (this.closeFuture == null) {
            DefaultRaftServer defaultRaftServer = this;
            synchronized (defaultRaftServer) {
                if (this.closeFuture == null) {
                    this.closeFuture = new CompletableFuture();
                    if (this.openFuture == null) {
                        this.cluster().leave().whenComplete((leaveResult, leaveError) -> this.shutdown().whenComplete((shutdownResult, shutdownError) -> {
                            this.context.delete();
                            this.closeFuture.complete(null);
                        }));
                    } else {
                        this.openFuture.whenComplete((openResult, openError) -> {
                            if (openError == null) {
                                this.cluster().leave().whenComplete((leaveResult, leaveError) -> this.shutdown().whenComplete((shutdownResult, shutdownError) -> {
                                    this.context.delete();
                                    this.closeFuture.complete(null);
                                }));
                            } else {
                                this.closeFuture.complete(null);
                            }
                        });
                    }
                }
            }
        }
        return this.closeFuture;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name()).toString();
    }

    public static class Builder
    extends RaftServer.Builder {
        public Builder(MemberId localMemberId) {
            super(localMemberId);
        }

        public RaftServer build() {
            if (this.serviceRegistry.size() == 0) {
                throw new IllegalStateException("No state machines registered");
            }
            if (this.name == null) {
                this.name = (String)((Object)this.localMemberId.id());
            }
            if (this.storage == null) {
                this.storage = RaftStorage.newBuilder().build();
            }
            RaftServerContext context = new RaftServerContext(this.name, this.type, this.localMemberId, this.protocol, this.storage, this.serviceRegistry, this.threadPoolSize);
            context.setElectionTimeout(this.electionTimeout).setHeartbeatInterval(this.heartbeatInterval).setSessionTimeout(this.sessionTimeout);
            return new DefaultRaftServer(context);
        }
    }
}

