/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.protocols.raft.cluster.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.protocols.raft.cluster.impl.DefaultRaftMember;
import io.atomix.protocols.raft.cluster.impl.RaftClusterContext;
import io.atomix.protocols.raft.storage.log.RaftLog;
import io.atomix.protocols.raft.storage.log.RaftLogReader;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public final class RaftMemberContext {
    private static final int MAX_APPENDS = 2;
    private static final int APPEND_WINDOW_SIZE = 8;
    private final DefaultRaftMember member;
    private long term;
    private long configIndex;
    private long snapshotIndex;
    private long nextSnapshotIndex;
    private int nextSnapshotOffset;
    private long matchIndex;
    private long heartbeatTime;
    private long heartbeatStartTime;
    private int appending;
    private boolean appendSucceeded;
    private long appendTime;
    private boolean configuring;
    private boolean installing;
    private volatile int failures;
    private volatile RaftLogReader reader;
    private final DescriptiveStatistics timeStats = new DescriptiveStatistics(8);

    RaftMemberContext(DefaultRaftMember member, RaftClusterContext cluster) {
        this.member = ((DefaultRaftMember)Preconditions.checkNotNull((Object)member, (Object)"member cannot be null")).setCluster(cluster);
    }

    public void resetState(RaftLog log) {
        this.snapshotIndex = 0L;
        this.nextSnapshotIndex = 0L;
        this.nextSnapshotOffset = 0;
        this.matchIndex = 0L;
        this.heartbeatTime = 0L;
        this.heartbeatStartTime = 0L;
        this.appending = 0;
        this.timeStats.clear();
        this.configuring = false;
        this.installing = false;
        this.appendSucceeded = false;
        this.failures = 0;
        switch (this.member.getType()) {
            case PASSIVE: {
                this.reader = log.openReader(log.writer().getLastIndex() + 1L, RaftLogReader.Mode.COMMITS);
                break;
            }
            case ACTIVE: {
                this.reader = log.openReader(log.writer().getLastIndex() + 1L, RaftLogReader.Mode.ALL);
            }
        }
    }

    public DefaultRaftMember getMember() {
        return this.member;
    }

    public RaftLogReader getLogReader() {
        return this.reader;
    }

    public long getConfigTerm() {
        return this.term;
    }

    public void setConfigTerm(long term) {
        this.term = term;
    }

    public long getConfigIndex() {
        return this.configIndex;
    }

    public void setConfigIndex(long configIndex) {
        this.configIndex = configIndex;
    }

    public long getSnapshotIndex() {
        return this.snapshotIndex;
    }

    public void setSnapshotIndex(long snapshotIndex) {
        this.snapshotIndex = snapshotIndex;
    }

    public long getNextSnapshotIndex() {
        return this.nextSnapshotIndex;
    }

    public void setNextSnapshotIndex(long nextSnapshotIndex) {
        this.nextSnapshotIndex = nextSnapshotIndex;
    }

    public int getNextSnapshotOffset() {
        return this.nextSnapshotOffset;
    }

    public void setNextSnapshotOffset(int nextSnapshotOffset) {
        this.nextSnapshotOffset = nextSnapshotOffset;
    }

    public long getMatchIndex() {
        return this.matchIndex;
    }

    public void setMatchIndex(long matchIndex) {
        Preconditions.checkArgument((matchIndex >= 0L ? 1 : 0) != 0, (Object)"matchIndex must be positive");
        this.matchIndex = matchIndex;
    }

    public boolean canAppend() {
        return this.appending == 0 || this.appendSucceeded && this.appending < 2 && (double)System.currentTimeMillis() - this.timeStats.getMean() / 2.0 >= (double)this.appendTime;
    }

    public boolean canHeartbeat() {
        return this.appending == 0;
    }

    public void appendSucceeded() {
        this.appendSucceeded(true);
    }

    public void appendFailed() {
        this.appendSucceeded(false);
    }

    private void appendSucceeded(boolean succeeded) {
        this.appendSucceeded = succeeded;
    }

    public void startAppend() {
        ++this.appending;
        this.appendTime = System.currentTimeMillis();
    }

    public void completeAppend() {
        --this.appending;
    }

    public void completeAppend(long time) {
        --this.appending;
        this.timeStats.addValue((double)time);
    }

    public boolean canConfigure() {
        return !this.configuring;
    }

    public void startConfigure() {
        this.configuring = true;
    }

    public void completeConfigure() {
        this.configuring = false;
    }

    public boolean canInstall() {
        return !this.installing;
    }

    public void startInstall() {
        this.installing = true;
    }

    public void completeInstall() {
        this.installing = false;
    }

    public long getHeartbeatTime() {
        return this.heartbeatTime;
    }

    public void setHeartbeatTime(long heartbeatTime) {
        this.heartbeatTime = heartbeatTime;
    }

    public long getHeartbeatStartTime() {
        return this.heartbeatStartTime;
    }

    public void setHeartbeatStartTime(long startTime) {
        this.heartbeatStartTime = startTime;
    }

    public int getFailureCount() {
        return this.failures;
    }

    public int incrementFailureCount() {
        return ++this.failures;
    }

    public void resetFailureCount() {
        this.failures = 0;
    }

    public String toString() {
        RaftLogReader reader = this.reader;
        return MoreObjects.toStringHelper((Object)this).add("member", (Object)this.member.memberId()).add("term", this.term).add("configIndex", this.configIndex).add("snapshotIndex", this.snapshotIndex).add("nextSnapshotIndex", this.nextSnapshotIndex).add("nextSnapshotOffset", this.nextSnapshotOffset).add("matchIndex", this.matchIndex).add("nextIndex", reader != null ? reader.getNextIndex() : this.matchIndex + 1L).add("heartbeatTime", this.heartbeatTime).add("heartbeatStartTime", this.heartbeatStartTime).add("appending", this.appending).add("appendSucceeded", this.appendSucceeded).add("appendTime", this.appendTime).add("configuring", this.configuring).add("installing", this.installing).add("failures", this.failures).toString();
    }

    private static class TimeBuffer {
        private final long[] buffer;
        private int position;

        TimeBuffer(int size) {
            this.buffer = new long[size];
        }

        void record(long time) {
            this.buffer[this.position++] = time;
            if (this.position >= this.buffer.length) {
                this.position = 0;
            }
        }

        long average() {
            long total = 0L;
            for (long time : this.buffer) {
                if (time <= 0L) continue;
                total += time;
            }
            return total / (long)this.buffer.length;
        }

        void reset() {
            for (int i = 0; i < this.buffer.length; ++i) {
                this.buffer[i] = 0L;
            }
            this.position = 0;
        }
    }
}

