/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.collect.Maps;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.messaging.ClusterCommunicationService;
import io.atomix.primitive.PrimitiveTypeRegistry;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.ManagedPartitionGroupMembershipService;
import io.atomix.primitive.partition.ManagedPartitionService;
import io.atomix.primitive.partition.ManagedPrimaryElectionService;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionGroupMembership;
import io.atomix.primitive.partition.PartitionGroupMembershipEvent;
import io.atomix.primitive.partition.PartitionGroupMembershipEventListener;
import io.atomix.primitive.partition.PartitionGroupTypeRegistry;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionService;
import io.atomix.primitive.partition.impl.DefaultPartitionGroupMembershipService;
import io.atomix.primitive.partition.impl.DefaultPartitionManagementService;
import io.atomix.primitive.partition.impl.DefaultPrimaryElectionService;
import io.atomix.primitive.partition.impl.HashBasedPrimaryElectionService;
import io.atomix.primitive.session.ManagedSessionIdService;
import io.atomix.primitive.session.impl.DefaultSessionIdService;
import io.atomix.primitive.session.impl.ReplicatedSessionIdService;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.config.ConfigurationException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPartitionService
implements ManagedPartitionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPartitionService.class);
    private final ClusterMembershipService clusterMembershipService;
    private final ClusterCommunicationService communicationService;
    private final PrimitiveTypeRegistry primitiveTypeRegistry;
    private final ManagedPartitionGroupMembershipService groupMembershipService;
    private ManagedPartitionGroup systemGroup;
    private volatile ManagedPrimaryElectionService systemElectionService;
    private volatile ManagedSessionIdService systemSessionIdService;
    private volatile ManagedPrimaryElectionService electionService;
    private volatile PartitionManagementService partitionManagementService;
    private final Map<String, ManagedPartitionGroup> groups = Maps.newConcurrentMap();
    private final PartitionGroupMembershipEventListener groupMembershipEventListener = this::handleMembershipChange;
    private final AtomicBoolean started = new AtomicBoolean();

    public DefaultPartitionService(ClusterMembershipService membershipService, ClusterCommunicationService messagingService, PrimitiveTypeRegistry primitiveTypeRegistry, ManagedPartitionGroup systemGroup, Collection<ManagedPartitionGroup> groups, PartitionGroupTypeRegistry groupTypeRegistry) {
        this.clusterMembershipService = membershipService;
        this.communicationService = messagingService;
        this.primitiveTypeRegistry = primitiveTypeRegistry;
        this.groupMembershipService = new DefaultPartitionGroupMembershipService(membershipService, messagingService, systemGroup, groups, groupTypeRegistry);
        this.systemGroup = systemGroup;
        groups.forEach(group -> this.groups.put(group.name(), (ManagedPartitionGroup)group));
    }

    @Override
    public PartitionGroup getSystemPartitionGroup() {
        return this.systemGroup;
    }

    @Override
    public PartitionGroup getPartitionGroup(String name) {
        ManagedPartitionGroup group = this.groups.get(name);
        if (group != null) {
            return group;
        }
        if (this.systemGroup != null && this.systemGroup.name().equals(name)) {
            return this.systemGroup;
        }
        return null;
    }

    @Override
    public Collection<PartitionGroup> getPartitionGroups() {
        return this.groups.values();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMembershipChange(PartitionGroupMembershipEvent event) {
        if (this.partitionManagementService == null) {
            return;
        }
        if (!event.membership().system()) {
            Map<String, ManagedPartitionGroup> map = this.groups;
            synchronized (map) {
                ManagedPartitionGroup group = this.groups.get(event.membership().group());
                if (group == null) {
                    group = ((PartitionGroup.Type)event.membership().config().getType()).newPartitionGroup(event.membership().config());
                    this.groups.put(event.membership().group(), group);
                    if (event.membership().members().contains(this.clusterMembershipService.getLocalMember().id())) {
                        group.join(this.partitionManagementService);
                    } else {
                        group.connect(this.partitionManagementService);
                    }
                }
            }
        }
    }

    public CompletableFuture<PartitionService> start() {
        this.groupMembershipService.addListener(this.groupMembershipEventListener);
        return ((CompletableFuture)((CompletableFuture)this.groupMembershipService.start().thenCompose(v -> {
            PartitionGroupMembership systemGroupMembership = this.groupMembershipService.getSystemMembership();
            if (systemGroupMembership != null) {
                if (this.systemGroup == null) {
                    this.systemGroup = ((PartitionGroup.Type)systemGroupMembership.config().getType()).newPartitionGroup(systemGroupMembership.config());
                }
                this.systemElectionService = new DefaultPrimaryElectionService(this.systemGroup);
                this.systemSessionIdService = new ReplicatedSessionIdService(this.systemGroup);
                this.electionService = new HashBasedPrimaryElectionService(this.clusterMembershipService, this.groupMembershipService, this.communicationService);
                return this.electionService.start().thenCompose(s -> {
                    DefaultPartitionManagementService managementService = new DefaultPartitionManagementService(this.clusterMembershipService, this.communicationService, this.primitiveTypeRegistry, this.electionService, new DefaultSessionIdService());
                    if (systemGroupMembership.members().contains(this.clusterMembershipService.getLocalMember().id())) {
                        return this.systemGroup.join(managementService);
                    }
                    return this.systemGroup.connect(managementService);
                });
            }
            return Futures.exceptionalFuture((Throwable)new ConfigurationException("No system partition group found"));
        })).thenCompose(v -> ((CompletableFuture)this.systemElectionService.start().thenCompose(v2 -> this.systemSessionIdService.start())).thenApply(v2 -> new DefaultPartitionManagementService(this.clusterMembershipService, this.communicationService, this.primitiveTypeRegistry, this.systemElectionService, this.systemSessionIdService)))).thenCompose(managementService -> {
            this.partitionManagementService = managementService;
            List<CompletableFuture> futures = this.groupMembershipService.getMemberships().stream().map(membership -> {
                ManagedPartitionGroup group;
                Map<String, ManagedPartitionGroup> map = this.groups;
                synchronized (map) {
                    group = this.groups.get(membership.group());
                    if (group == null) {
                        group = ((PartitionGroup.Type)membership.config().getType()).newPartitionGroup(membership.config());
                        this.groups.put(group.name(), group);
                    }
                }
                if (membership.members().contains(this.clusterMembershipService.getLocalMember().id())) {
                    return group.join(this.partitionManagementService);
                }
                return group.connect(this.partitionManagementService);
            }).collect(Collectors.toList());
            return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).thenApply(v -> {
                LOGGER.info("Started");
                this.started.set(true);
                return this;
            });
        });
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        this.groupMembershipService.removeListener(this.groupMembershipEventListener);
        Stream<CompletableFuture<Object>> systemStream = Stream.of(this.systemGroup != null ? this.systemGroup.close() : CompletableFuture.completedFuture(null));
        Stream<CompletableFuture> groupStream = this.groups.values().stream().map(ManagedPartitionGroup::close);
        List<CompletableFuture> futures = Stream.concat(systemStream, groupStream).collect(Collectors.toList());
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()])).exceptionally(throwable -> {
            LOGGER.error("Failed closing partition group(s)", throwable);
            return null;
        })).thenCompose(v -> this.electionService != null ? this.electionService.stop() : CompletableFuture.completedFuture(null))).exceptionally(throwable -> {
            LOGGER.error("Failed stopping election service", throwable);
            return null;
        })).thenCompose(v -> this.groupMembershipService.stop())).exceptionally(throwable -> {
            LOGGER.error("Failed stopping group membership service", throwable);
            return null;
        })).thenRun(() -> {
            LOGGER.info("Stopped");
            this.started.set(false);
        });
    }
}

