/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.service.impl;

import com.google.common.base.Preconditions;
import io.atomix.primitive.PrimitiveException;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.operation.OperationType;
import io.atomix.primitive.service.Commit;
import io.atomix.primitive.service.PrimitiveService;
import io.atomix.primitive.service.ServiceContext;
import io.atomix.primitive.service.ServiceExecutor;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.atomix.utils.serializer.Serializer;
import io.atomix.utils.time.WallClockTimestamp;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;

public class DefaultServiceExecutor
implements ServiceExecutor {
    private final Serializer serializer;
    private final ServiceContext context;
    private final Logger log;
    private final Queue<Runnable> tasks = new LinkedList<Runnable>();
    private final List<ScheduledTask> scheduledTasks = new ArrayList<ScheduledTask>();
    private final List<ScheduledTask> complete = new ArrayList<ScheduledTask>();
    private final Map<String, Function<Commit<byte[]>, byte[]>> operations = new HashMap<String, Function<Commit<byte[]>, byte[]>>();
    private OperationType operationType;
    private long timestamp;

    public DefaultServiceExecutor(ServiceContext context, Serializer serializer) {
        this.serializer = (Serializer)Preconditions.checkNotNull((Object)serializer);
        this.context = (ServiceContext)Preconditions.checkNotNull((Object)context);
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(PrimitiveService.class).addValue((Object)context.serviceId()).add("type", (Object)context.serviceType()).add("name", (Object)context.serviceName()).build());
    }

    protected <T> byte[] encode(T object) {
        return object != null ? this.serializer.encode(object) : null;
    }

    protected <T> T decode(byte[] bytes) {
        return (T)(bytes != null ? this.serializer.decode(bytes) : null);
    }

    @Override
    public void tick(WallClockTimestamp timestamp) {
        long unixTimestamp = timestamp.unixTimestamp();
        this.operationType = OperationType.COMMAND;
        if (!this.scheduledTasks.isEmpty()) {
            ScheduledTask task;
            Iterator<ScheduledTask> iterator = this.scheduledTasks.iterator();
            while (iterator.hasNext() && (task = iterator.next()).isRunnable(unixTimestamp)) {
                this.timestamp = task.time;
                this.operationType = OperationType.COMMAND;
                this.log.trace("Executing scheduled task {}", (Object)task);
                task.execute();
                this.complete.add(task);
                iterator.remove();
            }
            for (ScheduledTask task2 : this.complete) {
                task2.reschedule(this.timestamp);
            }
            this.complete.clear();
        }
    }

    private void checkOperation(OperationType type, String message) {
        Preconditions.checkState((this.operationType == type ? 1 : 0) != 0, (Object)message);
    }

    @Override
    public void handle(OperationId operationId, Function<Commit<byte[]>, byte[]> callback) {
        Preconditions.checkNotNull((Object)operationId, (Object)"operationId cannot be null");
        Preconditions.checkNotNull(callback, (Object)"callback cannot be null");
        this.operations.put((String)((Object)operationId.id()), callback);
        this.log.debug("Registered operation callback {}", (Object)operationId);
    }

    @Override
    public <R> void register(OperationId operationId, Supplier<R> callback) {
        Preconditions.checkNotNull((Object)operationId, (Object)"operationId cannot be null");
        Preconditions.checkNotNull(callback, (Object)"callback cannot be null");
        this.handle(operationId, commit -> this.encode(callback.get()));
    }

    @Override
    public <T> void register(OperationId operationId, Consumer<Commit<T>> callback) {
        Preconditions.checkNotNull((Object)operationId, (Object)"operationId cannot be null");
        Preconditions.checkNotNull(callback, (Object)"callback cannot be null");
        this.handle(operationId, commit -> {
            callback.accept(commit.map(this::decode));
            return null;
        });
    }

    @Override
    public <T, R> void register(OperationId operationId, Function<Commit<T>, R> callback) {
        Preconditions.checkNotNull((Object)operationId, (Object)"operationId cannot be null");
        Preconditions.checkNotNull(callback, (Object)"callback cannot be null");
        this.handle(operationId, commit -> this.encode(callback.apply(commit.map(this::decode))));
    }

    @Override
    public byte[] apply(Commit<byte[]> commit) {
        this.log.trace("Executing {}", commit);
        this.operationType = commit.operation().type();
        this.timestamp = commit.wallClockTime().unixTimestamp();
        Function<Commit<byte[]>, byte[]> operation = this.operations.get(commit.operation().id());
        if (operation == null) {
            throw new IllegalStateException("Unknown state machine operation: " + commit.operation());
        }
        try {
            byte[] byArray = operation.apply(commit);
            return byArray;
        }
        catch (Exception e) {
            this.log.warn("State machine operation failed: {}", (Object)e.getMessage());
            throw new PrimitiveException.ServiceException();
        }
        finally {
            this.runTasks();
        }
    }

    private void runTasks() {
        if (!this.tasks.isEmpty()) {
            for (Runnable task : this.tasks) {
                this.log.trace("Executing task {}", (Object)task);
                task.run();
            }
            this.tasks.clear();
        }
    }

    @Override
    public void execute(Runnable callback) {
        this.checkOperation(OperationType.COMMAND, "callbacks can only be scheduled during command execution");
        Preconditions.checkNotNull((Object)callback, (Object)"callback cannot be null");
        this.tasks.add(callback);
    }

    public Scheduled schedule(Duration delay, Runnable callback) {
        this.checkOperation(OperationType.COMMAND, "callbacks can only be scheduled during command execution");
        Preconditions.checkArgument((!delay.isNegative() ? 1 : 0) != 0, (Object)"delay cannot be negative");
        Preconditions.checkNotNull((Object)callback, (Object)"callback cannot be null");
        this.log.trace("Scheduled callback {} with delay {}", (Object)callback, (Object)delay);
        return new ScheduledTask(callback, delay.toMillis()).schedule();
    }

    public Scheduled schedule(Duration initialDelay, Duration interval, Runnable callback) {
        this.checkOperation(OperationType.COMMAND, "callbacks can only be scheduled during command execution");
        Preconditions.checkArgument((!initialDelay.isNegative() ? 1 : 0) != 0, (Object)"initialDelay cannot be negative");
        Preconditions.checkArgument((!interval.isNegative() ? 1 : 0) != 0, (Object)"interval cannot be negative");
        Preconditions.checkNotNull((Object)callback, (Object)"callback cannot be null");
        this.log.trace("Scheduled repeating callback {} with initial delay {} and interval {}", new Object[]{callback, initialDelay, interval});
        return new ScheduledTask(callback, initialDelay.toMillis(), interval.toMillis()).schedule();
    }

    private class ScheduledTask
    implements Scheduled {
        private final long interval;
        private final Runnable callback;
        private long time;

        private ScheduledTask(Runnable callback, long delay) {
            this(callback, delay, 0L);
        }

        private ScheduledTask(Runnable callback, long delay, long interval) {
            this.interval = interval;
            this.callback = callback;
            this.time = DefaultServiceExecutor.this.timestamp + delay;
        }

        private Scheduled schedule() {
            if (!DefaultServiceExecutor.this.scheduledTasks.isEmpty()) {
                int i;
                int l = 0;
                int u = DefaultServiceExecutor.this.scheduledTasks.size() - 1;
                while (true) {
                    i = (u + l) / 2;
                    long t = ((ScheduledTask)((DefaultServiceExecutor)DefaultServiceExecutor.this).scheduledTasks.get((int)i)).time;
                    if (t == this.time) {
                        DefaultServiceExecutor.this.scheduledTasks.add(i, this);
                        return this;
                    }
                    if (t < this.time) {
                        l = i + 1;
                        if (l <= u) continue;
                        DefaultServiceExecutor.this.scheduledTasks.add(i + 1, this);
                        return this;
                    }
                    u = i - 1;
                    if (l > u) break;
                }
                DefaultServiceExecutor.this.scheduledTasks.add(i, this);
                return this;
            }
            DefaultServiceExecutor.this.scheduledTasks.add(this);
            return this;
        }

        private void reschedule(long timestamp) {
            if (this.interval > 0L) {
                this.time = timestamp + this.interval;
                this.schedule();
            }
        }

        private boolean isRunnable(long timestamp) {
            return timestamp > this.time;
        }

        private synchronized void execute() {
            try {
                this.callback.run();
            }
            catch (Exception e) {
                DefaultServiceExecutor.this.log.error("An exception occurred in a scheduled task", (Throwable)e);
            }
        }

        public synchronized void cancel() {
            DefaultServiceExecutor.this.scheduledTasks.remove(this);
        }
    }
}

