/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.session.impl;

import com.google.common.collect.Maps;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.event.EventType;
import io.atomix.primitive.event.PrimitiveEvent;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.session.SessionClient;
import io.atomix.primitive.session.impl.DelegatingSessionClient;
import io.atomix.utils.concurrent.Futures;
import io.atomix.utils.concurrent.ThreadContext;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class BlockingAwareSessionClient
extends DelegatingSessionClient {
    private final ThreadContext context;
    private final Map<Consumer<PrimitiveState>, Consumer<PrimitiveState>> stateChangeListeners = Maps.newConcurrentMap();
    private final Map<Consumer<PrimitiveEvent>, Consumer<PrimitiveEvent>> eventListeners = Maps.newConcurrentMap();
    private volatile CompletableFuture<SessionClient> connectFuture;
    private volatile CompletableFuture<Void> closeFuture;

    public BlockingAwareSessionClient(SessionClient session, ThreadContext context) {
        super(session);
        this.context = context;
    }

    @Override
    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        Consumer<PrimitiveState> wrappedListener = state -> this.context.execute(() -> listener.accept((PrimitiveState)((Object)state)));
        this.stateChangeListeners.put(listener, wrappedListener);
        super.addStateChangeListener(wrappedListener);
    }

    @Override
    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        Consumer<PrimitiveState> wrappedListener = this.stateChangeListeners.remove(listener);
        if (wrappedListener != null) {
            super.removeStateChangeListener(wrappedListener);
        }
    }

    @Override
    public CompletableFuture<byte[]> execute(PrimitiveOperation operation) {
        return Futures.asyncFuture(super.execute(operation), (Executor)this.context);
    }

    @Override
    public void addEventListener(EventType eventType, Consumer<PrimitiveEvent> listener) {
        Consumer<PrimitiveEvent> wrappedListener = e -> this.context.execute(() -> listener.accept((PrimitiveEvent)e));
        this.eventListeners.put(listener, wrappedListener);
        super.addEventListener(eventType, wrappedListener);
    }

    @Override
    public void removeEventListener(EventType eventType, Consumer<PrimitiveEvent> listener) {
        Consumer<PrimitiveEvent> wrappedListener = this.eventListeners.remove(listener);
        if (wrappedListener != null) {
            super.removeEventListener(eventType, wrappedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<SessionClient> connect() {
        if (this.connectFuture == null) {
            BlockingAwareSessionClient blockingAwareSessionClient = this;
            synchronized (blockingAwareSessionClient) {
                if (this.connectFuture == null) {
                    this.connectFuture = Futures.orderedFuture((CompletableFuture)Futures.asyncFuture(super.connect(), (Executor)this.context));
                }
            }
        }
        return this.connectFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompletableFuture<Void> close() {
        if (this.closeFuture == null) {
            BlockingAwareSessionClient blockingAwareSessionClient = this;
            synchronized (blockingAwareSessionClient) {
                if (this.closeFuture == null) {
                    this.closeFuture = Futures.orderedFuture((CompletableFuture)Futures.asyncFuture(super.close(), (Executor)this.context));
                }
            }
        }
        return this.closeFuture;
    }
}

