/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.operation.OperationId;
import io.atomix.primitive.operation.OperationType;
import io.atomix.primitive.partition.GroupMember;
import io.atomix.primitive.partition.MemberGroupId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Namespaces;

public enum PrimaryElectorOperations implements OperationId
{
    ENTER(OperationType.COMMAND),
    GET_TERM(OperationType.QUERY);

    private final OperationType type;
    public static final Namespace NAMESPACE;

    private PrimaryElectorOperations(OperationType type) {
        this.type = type;
    }

    public String id() {
        return this.name();
    }

    @Override
    public OperationType type() {
        return this.type;
    }

    static {
        NAMESPACE = Namespace.builder().register(Namespaces.BASIC).nextId(500).register(new Class[]{Enter.class}).register(new Class[]{GetTerm.class}).register(new Class[]{GroupMember.class}).register(new Class[]{MemberId.class}).register(new Class[]{MemberId.Type.class}).register(new Class[]{MemberGroupId.class}).register(new Class[]{PartitionId.class}).build(PrimaryElectorOperations.class.getSimpleName());
    }

    public static class Enter
    extends PartitionOperation {
        private GroupMember member;

        Enter() {
        }

        Enter(PartitionId partitionId, GroupMember member) {
            super(partitionId);
            this.member = member;
        }

        public GroupMember member() {
            return this.member;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("partition", (Object)this.partitionId).add("member", (Object)this.member).toString();
        }
    }

    public static class GetTerm
    extends PartitionOperation {
        public GetTerm() {
        }

        public GetTerm(PartitionId partitionId) {
            super(partitionId);
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("partition", (Object)this.partitionId).toString();
        }
    }

    public static abstract class PartitionOperation
    extends ElectorOperation {
        protected PartitionId partitionId;

        public PartitionOperation() {
        }

        public PartitionOperation(PartitionId partitionId) {
            this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId);
        }

        public PartitionId partitionId() {
            return this.partitionId;
        }
    }

    public static abstract class ElectorOperation {
    }
}

