/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.atomix.primitive.operation.PrimitiveOperation;
import io.atomix.primitive.partition.GroupMember;
import io.atomix.primitive.partition.ManagedPrimaryElection;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PrimaryElection;
import io.atomix.primitive.partition.PrimaryElectionEventListener;
import io.atomix.primitive.partition.PrimaryElectionService;
import io.atomix.primitive.partition.PrimaryTerm;
import io.atomix.primitive.partition.impl.PrimaryElectorEvents;
import io.atomix.primitive.partition.impl.PrimaryElectorOperations;
import io.atomix.primitive.session.SessionClient;
import io.atomix.utils.serializer.Namespace;
import io.atomix.utils.serializer.Serializer;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultPrimaryElection
implements ManagedPrimaryElection {
    private static final Serializer SERIALIZER = Serializer.using((Namespace)Namespace.builder().register(PrimaryElectorOperations.NAMESPACE).register(PrimaryElectorEvents.NAMESPACE).build());
    private final PartitionId partitionId;
    private final SessionClient proxy;
    private final PrimaryElectionService service;
    private final Set<PrimaryElectionEventListener> listeners = Sets.newCopyOnWriteArraySet();
    private final PrimaryElectionEventListener eventListener;
    private final AtomicBoolean started = new AtomicBoolean();

    public DefaultPrimaryElection(PartitionId partitionId, SessionClient proxy, PrimaryElectionService service) {
        this.partitionId = (PartitionId)Preconditions.checkNotNull((Object)partitionId);
        this.proxy = proxy;
        this.service = service;
        this.eventListener = event -> {
            if (event.partitionId().equals(partitionId)) {
                this.listeners.forEach(l -> l.onEvent(event));
            }
        };
    }

    @Override
    public CompletableFuture<PrimaryTerm> enter(GroupMember member) {
        return this.proxy.execute(PrimitiveOperation.operation(PrimaryElectorOperations.ENTER, SERIALIZER.encode((Object)new PrimaryElectorOperations.Enter(this.partitionId, member)))).thenApply(arg_0 -> ((Serializer)SERIALIZER).decode(arg_0));
    }

    @Override
    public CompletableFuture<PrimaryTerm> getTerm() {
        return this.proxy.execute(PrimitiveOperation.operation(PrimaryElectorOperations.GET_TERM, SERIALIZER.encode((Object)new PrimaryElectorOperations.GetTerm(this.partitionId)))).thenApply(arg_0 -> ((Serializer)SERIALIZER).decode(arg_0));
    }

    public synchronized void addListener(PrimaryElectionEventListener listener) {
        this.listeners.add((PrimaryElectionEventListener)Preconditions.checkNotNull((Object)listener));
    }

    public synchronized void removeListener(PrimaryElectionEventListener listener) {
        this.listeners.remove(Preconditions.checkNotNull((Object)listener));
    }

    public CompletableFuture<PrimaryElection> start() {
        this.service.addListener(this.eventListener);
        this.started.set(true);
        return CompletableFuture.completedFuture(this);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        this.service.removeListener(this.eventListener);
        this.started.set(false);
        return CompletableFuture.completedFuture(null);
    }
}

