/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.primitive.AsyncPrimitive;
import io.atomix.primitive.PrimitiveState;
import io.atomix.primitive.PrimitiveType;
import io.atomix.primitive.protocol.PrimitiveProtocol;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public abstract class DelegatingAsyncPrimitive
implements AsyncPrimitive {
    private final AsyncPrimitive primitive;

    public DelegatingAsyncPrimitive(AsyncPrimitive primitive) {
        this.primitive = (AsyncPrimitive)Preconditions.checkNotNull((Object)primitive);
    }

    @Override
    public String name() {
        return this.primitive.name();
    }

    @Override
    public PrimitiveType type() {
        return this.primitive.type();
    }

    @Override
    public PrimitiveProtocol protocol() {
        return this.primitive.protocol();
    }

    @Override
    public CompletableFuture<Void> delete() {
        return this.primitive.delete();
    }

    @Override
    public void addStateChangeListener(Consumer<PrimitiveState> listener) {
        this.primitive.addStateChangeListener(listener);
    }

    @Override
    public void removeStateChangeListener(Consumer<PrimitiveState> listener) {
        this.primitive.removeStateChangeListener(listener);
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.primitive.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("delegate", (Object)this.primitive).toString();
    }

    public int hashCode() {
        return Objects.hash(this.primitive);
    }

    public boolean equals(Object other) {
        return other instanceof DelegatingAsyncPrimitive && this.primitive.equals(((DelegatingAsyncPrimitive)other).primitive);
    }
}

