/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.protocol;

import io.atomix.primitive.protocol.PrimitiveProtocol;
import io.atomix.primitive.protocol.PrimitiveProtocolConfig;
import io.atomix.primitive.protocol.PrimitiveProtocolFactory;
import io.atomix.utils.ConfigurationException;
import io.atomix.utils.Services;

public class PrimitiveProtocols {
    public static PrimitiveProtocol createProtocol(PrimitiveProtocolConfig config) {
        for (PrimitiveProtocolFactory factory : Services.loadAll(PrimitiveProtocolFactory.class)) {
            if (!factory.configClass().isAssignableFrom(config.getClass())) continue;
            return factory.create(config);
        }
        throw new ConfigurationException("Unknown protocol configuration type: " + config.getClass().getSimpleName());
    }

    public static PrimitiveProtocolFactory getProtocolFactory(String type) {
        for (PrimitiveProtocolFactory factory : Services.loadAll(PrimitiveProtocolFactory.class)) {
            if (!factory.type().name().equals(type)) continue;
            return factory;
        }
        throw new ConfigurationException("Unknown protocol type: " + type);
    }

    private PrimitiveProtocols() {
    }
}

